/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GroupedMap
extends LinkedHashMap<String, LinkedHashMap<String, String>> {
    private static final long serialVersionUID = -7777365130776081931L;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();
    private int size = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String group, String key2) {
        this.readLock.lock();
        try {
            Object map2 = this.get(StrUtil.nullToEmpty(group));
            if (MapUtil.isNotEmpty(map2)) {
                String string2 = (String)((LinkedHashMap)map2).get(key2);
                return string2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, String> get(Object key2) {
        this.readLock.lock();
        try {
            LinkedHashMap linkedHashMap = (LinkedHashMap)super.get(key2);
            return linkedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.writeLock.lock();
        try {
            if (this.size < 0) {
                this.size = 0;
                for (LinkedHashMap value : this.values()) {
                    this.size += value.size();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String group, String key2, String value) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            LinkedHashMap valueMap = this.computeIfAbsent(group, k -> new LinkedHashMap());
            this.size = -1;
            String string2 = valueMap.put(key2, value);
            return string2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public GroupedMap putAll(String group, Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            this.put(group, entry.getKey(), entry.getValue());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(String group, String key2) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                String string2 = (String)((HashMap)valueMap).remove(key2);
                return string2;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                boolean bl = ((HashMap)valueMap).isEmpty();
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String group, String key2) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                boolean bl = ((HashMap)valueMap).containsKey(key2);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(String group, String value) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                boolean bl = ((LinkedHashMap)valueMap).containsValue(value);
                return bl;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    public GroupedMap clear(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.writeLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                ((LinkedHashMap)valueMap).clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return this;
    }

    @Override
    public Set<String> keySet() {
        this.readLock.lock();
        try {
            Set<String> set2 = super.keySet();
            return set2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Set<String> set2 = ((LinkedHashMap)valueMap).keySet();
                return set2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> values(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Collection<String> collection = ((LinkedHashMap)valueMap).values();
                return collection;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<Map.Entry<String, LinkedHashMap<String, String>>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<String, LinkedHashMap<String, String>>> set2 = super.entrySet();
            return set2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, String>> entrySet(String group) {
        group = StrUtil.nullToEmpty(group).trim();
        this.readLock.lock();
        try {
            Object valueMap = this.get(group);
            if (MapUtil.isNotEmpty(valueMap)) {
                Set<Map.Entry<String, String>> set2 = ((LinkedHashMap)valueMap).entrySet();
                return set2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string2 = super.toString();
            return string2;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

