/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.word;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class TableUtil {
    public static XWPFTable createTable(XWPFDocument doc2) {
        return TableUtil.createTable(doc2, null);
    }

    public static XWPFTable createTable(XWPFDocument doc2, Iterable<?> data2) {
        Assert.notNull(doc2, "XWPFDocument must be not null !", new Object[0]);
        XWPFTable table = doc2.createTable();
        table.removeRow(0);
        return TableUtil.writeTable(table, data2);
    }

    public static XWPFTable writeTable(XWPFTable table, Iterable<?> data2) {
        Assert.notNull(table, "XWPFTable must be not null !", new Object[0]);
        if (IterUtil.isEmpty(data2)) {
            return table;
        }
        boolean isFirst = true;
        for (Object rowData : data2) {
            TableUtil.writeRow(table.createRow(), rowData, isFirst);
            if (!isFirst) continue;
            isFirst = false;
        }
        return table;
    }

    public static void writeRow(XWPFTableRow row, Object rowBean, boolean isWriteKeyAsHead) {
        Map<String, Object> rowMap;
        if (rowBean instanceof Iterable) {
            TableUtil.writeRow(row, (Iterable)rowBean);
            return;
        }
        if (rowBean instanceof Map) {
            rowMap = (Map<String, Object>)rowBean;
        } else if (BeanUtil.isBean(rowBean.getClass())) {
            rowMap = BeanUtil.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false);
        } else {
            TableUtil.writeRow(row, CollUtil.newArrayList(rowBean), isWriteKeyAsHead);
            return;
        }
        TableUtil.writeRow(row, rowMap, isWriteKeyAsHead);
    }

    public static void writeRow(XWPFTableRow row, Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        if (MapUtil.isEmpty(rowMap)) {
            return;
        }
        if (isWriteKeyAsHead) {
            TableUtil.writeRow(row, rowMap.keySet());
            row = row.getTable().createRow();
        }
        TableUtil.writeRow(row, rowMap.values());
    }

    public static void writeRow(XWPFTableRow row, Iterable<?> rowData) {
        int index2 = 0;
        for (Object cellData : rowData) {
            XWPFTableCell cell = TableUtil.getOrCreateCell(row, index2);
            cell.setText(Convert.toStr(cellData));
            ++index2;
        }
    }

    public static XWPFTableRow getOrCreateRow(XWPFTable table, int index2) {
        XWPFTableRow row = table.getRow(index2);
        if (null == row) {
            row = table.createRow();
        }
        return row;
    }

    public static XWPFTableCell getOrCreateCell(XWPFTableRow row, int index2) {
        XWPFTableCell cell = row.getCell(index2);
        if (null == cell) {
            cell = row.createCell();
        }
        return cell;
    }
}

