/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.reader;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.reader.MapSheetReader;
import cn.hutool.poi.excel.reader.SheetReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;

public class BeanSheetReader<T>
implements SheetReader<List<T>> {
    private final Class<T> beanClass;
    private final MapSheetReader mapSheetReader;

    public BeanSheetReader(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanClass) {
        this.mapSheetReader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        this.beanClass = beanClass;
    }

    @Override
    public List<T> read(Sheet sheet) {
        Object mapList = this.mapSheetReader.read(sheet);
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return mapList;
        }
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        Iterator iterator = mapList.iterator();
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            beanList.add(BeanUtil.toBeanIgnoreError(map2, this.beanClass));
        }
        return beanList;
    }

    public void setCellEditor(CellEditor cellEditor) {
        this.mapSheetReader.setCellEditor(cellEditor);
    }

    public void setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.mapSheetReader.setIgnoreEmptyRow(ignoreEmptyRow);
    }

    public void setHeaderAlias(Map<String, String> headerAlias) {
        this.mapSheetReader.setHeaderAlias(headerAlias);
    }

    public void addHeaderAlias(String header, String alias2) {
        this.mapSheetReader.addHeaderAlias(header, alias2);
    }
}

