/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONStrFormatter;
import cn.hutool.json.JSONString;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONArraySerializer;
import cn.hutool.json.serialize.JSONDeserializer;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    public static JSONObject createObj() {
        return new JSONObject();
    }

    public static JSONObject createObj(JSONConfig config) {
        return new JSONObject(config);
    }

    public static JSONArray createArray() {
        return new JSONArray();
    }

    public static JSONArray createArray(JSONConfig config) {
        return new JSONArray(config);
    }

    public static JSONObject parseObj(String jsonStr) {
        return new JSONObject(jsonStr);
    }

    public static JSONObject parseObj(Object obj) {
        return JSONUtil.parseObj(obj, null);
    }

    public static JSONObject parseObj(Object obj, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.create();
            if (InternalJSONUtil.isOrder(obj)) {
                config.setOrder(true);
            }
        }
        return new JSONObject(obj, config);
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue) {
        return JSONUtil.parseObj(obj, ignoreNullValue, InternalJSONUtil.isOrder(obj));
    }

    public static JSONObject parseObj(Object obj, boolean ignoreNullValue, boolean isOrder) {
        return new JSONObject(obj, ignoreNullValue, isOrder);
    }

    public static JSONArray parseArray(String jsonStr) {
        return new JSONArray(jsonStr);
    }

    public static JSONArray parseArray(Object arrayOrCollection) {
        return JSONUtil.parseArray(arrayOrCollection, null);
    }

    public static JSONArray parseArray(Object arrayOrCollection, JSONConfig config) {
        return new JSONArray(arrayOrCollection, config);
    }

    public static JSONArray parseArray(Object arrayOrCollection, boolean ignoreNullValue) {
        return new JSONArray(arrayOrCollection, ignoreNullValue);
    }

    public static JSON parse(Object obj) {
        return JSONUtil.parse(obj, null);
    }

    public static JSON parse(Object obj, JSONConfig config) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        JSON json = obj instanceof JSON ? (JSON)obj : (obj instanceof CharSequence ? (JSONUtil.isJsonArray(jsonStr = StrUtil.trim((CharSequence)obj)) ? JSONUtil.parseArray((Object)jsonStr, config) : JSONUtil.parseObj((Object)jsonStr, config)) : (obj instanceof MapWrapper ? JSONUtil.parseObj(obj, config) : (obj instanceof Iterable || obj instanceof Iterator || ArrayUtil.isArray(obj) ? JSONUtil.parseArray(obj, config) : JSONUtil.parseObj(obj, config))));
        return json;
    }

    public static JSONObject parseFromXml(String xmlStr) {
        return XML.toJSONObject(xmlStr);
    }

    public static JSON readJSON(File file2, Charset charset) throws IORuntimeException {
        return JSONUtil.parse(FileReader.create(file2, charset).readString());
    }

    public static JSONObject readJSONObject(File file2, Charset charset) throws IORuntimeException {
        return JSONUtil.parseObj(FileReader.create(file2, charset).readString());
    }

    public static JSONArray readJSONArray(File file2, Charset charset) throws IORuntimeException {
        return JSONUtil.parseArray(FileReader.create(file2, charset).readString());
    }

    public static String toJsonStr(JSON json, int indentFactor) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(indentFactor);
    }

    public static String toJsonStr(JSON json) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(0);
    }

    public static void toJsonStr(JSON json, Writer writer2) {
        if (null != json) {
            json.write(writer2);
        }
    }

    public static String toJsonPrettyStr(JSON json) {
        if (null == json) {
            return null;
        }
        return json.toJSONString(4);
    }

    public static String toJsonStr(Object obj) {
        return JSONUtil.toJsonStr(obj, (JSONConfig)null);
    }

    public static String toJsonStr(Object obj, JSONConfig jsonConfig) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.str((CharSequence)obj);
        }
        return JSONUtil.toJsonStr(JSONUtil.parse(obj, jsonConfig));
    }

    public static void toJsonStr(Object obj, Writer writer2) {
        if (null != obj) {
            JSONUtil.toJsonStr(JSONUtil.parse(obj), writer2);
        }
    }

    public static String toJsonPrettyStr(Object obj) {
        return JSONUtil.toJsonPrettyStr(JSONUtil.parse(obj));
    }

    public static String toXmlStr(JSON json) {
        return XML.toXml(json);
    }

    public static <T> T toBean(String jsonString, Class<T> beanClass) {
        return JSONUtil.toBean(JSONUtil.parseObj(jsonString), beanClass);
    }

    public static <T> T toBean(JSONObject json, Class<T> beanClass) {
        return null == json ? null : (T)json.toBean(beanClass);
    }

    public static <T> T toBean(String jsonString, TypeReference<T> typeReference, boolean ignoreError) {
        return JSONUtil.toBean(jsonString, typeReference.getType(), ignoreError);
    }

    public static <T> T toBean(String jsonString, Type beanType, boolean ignoreError) {
        return JSONUtil.toBean(JSONUtil.parse(jsonString), beanType, ignoreError);
    }

    public static <T> T toBean(JSON json, TypeReference<T> typeReference, boolean ignoreError) {
        return JSONUtil.toBean(json, typeReference.getType(), ignoreError);
    }

    public static <T> T toBean(JSON json, Type beanType, boolean ignoreError) {
        if (null == json) {
            return null;
        }
        return json.toBean(beanType, ignoreError);
    }

    public static <T> List<T> toList(String jsonArray, Class<T> elementType) {
        return JSONUtil.toList(JSONUtil.parseArray(jsonArray), elementType);
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return null == jsonArray ? null : jsonArray.toList(elementType);
    }

    public static Object getByPath(JSON json, String expression) {
        return JSONUtil.getByPath(json, expression, null);
    }

    public static <T> T getByPath(JSON json, String expression, T defaultValue) {
        if (null == json || StrUtil.isBlank(expression)) {
            return defaultValue;
        }
        if (null != defaultValue) {
            Class<?> type2 = defaultValue.getClass();
            return (T)ObjectUtil.defaultIfNull(json.getByPath(expression, type2), defaultValue);
        }
        return (T)json.getByPath(expression);
    }

    public static void putByPath(JSON json, String expression, Object value) {
        json.putByPath(expression, value);
    }

    public static String quote(String string2) {
        return JSONUtil.quote(string2, true);
    }

    public static String quote(String string2, boolean isWrap) {
        StringWriter sw = new StringWriter();
        try {
            return JSONUtil.quote(string2, sw, isWrap).toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public static Writer quote(String str2, Writer writer2) throws IOException {
        return JSONUtil.quote(str2, writer2, true);
    }

    public static Writer quote(String str2, Writer writer2, boolean isWrap) throws IOException {
        if (StrUtil.isEmpty(str2)) {
            if (isWrap) {
                writer2.write("\"\"");
            }
            return writer2;
        }
        int len = str2.length();
        if (isWrap) {
            writer2.write(34);
        }
        block3: for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer2.write("\\");
                    writer2.write(c);
                    continue block3;
                }
                default: {
                    writer2.write(JSONUtil.escape(c));
                }
            }
        }
        if (isWrap) {
            writer2.write(34);
        }
        return writer2;
    }

    public static String escape(String str2) {
        if (StrUtil.isEmpty(str2)) {
            return str2;
        }
        int len = str2.length();
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str2.charAt(i);
            builder.append(JSONUtil.escape(c));
        }
        return builder.toString();
    }

    public static Object wrap(Object object, JSONConfig jsonConfig) {
        Type jsonType;
        if (object == null) {
            return jsonConfig.isIgnoreNullValue() ? null : JSONNull.NULL;
        }
        if (object instanceof JSON || JSONNull.NULL.equals(object) || object instanceof JSONString || object instanceof CharSequence || object instanceof Number || ObjectUtil.isBasicType(object)) {
            return object;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(object.getClass());
        if (null != serializer && null != (jsonType = TypeUtil.getTypeArgument(serializer.getClass()))) {
            if (serializer instanceof JSONObjectSerializer) {
                serializer.serialize(new JSONObject(jsonConfig), object);
            } else if (serializer instanceof JSONArraySerializer) {
                serializer.serialize(new JSONArray(jsonConfig), object);
            }
        }
        try {
            if (object instanceof SQLException) {
                return object.toString();
            }
            if (object instanceof Iterable || ArrayUtil.isArray(object)) {
                return new JSONArray(object, jsonConfig);
            }
            if (object instanceof Map) {
                return new JSONObject(object, jsonConfig);
            }
            if (object instanceof Date || object instanceof Calendar || object instanceof TemporalAccessor) {
                return object;
            }
            if (object instanceof Enum) {
                return object.toString();
            }
            if (ClassUtil.isJdkClass(object.getClass())) {
                return object.toString();
            }
            return new JSONObject(object, jsonConfig);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String formatJsonStr(String jsonStr) {
        return JSONStrFormatter.format(jsonStr);
    }

    public static boolean isJson(String str2) {
        return JSONUtil.isJsonObj(str2) || JSONUtil.isJsonArray(str2);
    }

    public static boolean isJsonObj(String str2) {
        if (StrUtil.isBlank(str2)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str2), '{', '}');
    }

    public static boolean isJsonArray(String str2) {
        if (StrUtil.isBlank(str2)) {
            return false;
        }
        return StrUtil.isWrap((CharSequence)StrUtil.trim(str2), '[', ']');
    }

    public static boolean isNull(Object obj) {
        return null == obj || obj instanceof JSONNull;
    }

    public static JSONObject xmlToJson(String xml2) {
        return XML.toJSONObject(xml2);
    }

    public static void putSerializer(Type type2, JSONArraySerializer<?> serializer) {
        GlobalSerializeMapping.put(type2, serializer);
    }

    public static void putSerializer(Type type2, JSONObjectSerializer<?> serializer) {
        GlobalSerializeMapping.put(type2, serializer);
    }

    public static void putDeserializer(Type type2, JSONDeserializer<?> deserializer) {
        GlobalSerializeMapping.put(type2, deserializer);
    }

    private static String escape(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        if (c < ' ' || c >= '\u0080' && c <= '\u00a0' || c >= '\u2000' && c <= '\u2010' || c >= '\u2028' && c <= '\u202f' || c >= '\u2066' && c <= '\u206f') {
            return HexUtil.toUnicodeHex(c);
        }
        return Character.toString(c);
    }
}

