/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ssh.JschUtil;
import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public enum JschSessionPool {
    INSTANCE;

    private final SimpleCache<String, Session> cache = new SimpleCache(new HashMap());

    public Session get(String key2) {
        return this.cache.get(key2);
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key2 = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key2, Session::isConnected, () -> JschUtil.openSession(sshHost, sshPort, sshUser, sshPass));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String prvkey, byte[] passphrase) {
        String key2 = StrUtil.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key2, Session::isConnected, () -> JschUtil.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public void put(String key2, Session session) {
        this.cache.put(key2, session);
    }

    public void close(String key2) {
        Session session = this.get(key2);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.cache.remove(key2);
    }

    public void remove(Session session) {
        if (null != session) {
            Iterator<Map.Entry<String, Session>> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Session> entry = iterator.next();
                if (!session.equals(entry.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void closeAll() {
        for (Map.Entry<String, Session> entry : this.cache) {
            Session session = entry.getValue();
            if (session == null || !session.isConnected()) continue;
            session.disconnect();
        }
        this.cache.clear();
    }
}

