/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.cglib;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.cglib.BeanCopierCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.beans.BeanMap;
import net.sf.cglib.core.Converter;

public class CglibUtil {
    public static <T> T copy(Object source2, Class<T> targetClass) {
        return CglibUtil.copy(source2, targetClass, null);
    }

    public static <T> T copy(Object source2, Class<T> targetClass, Converter converter) {
        T target = ReflectUtil.newInstanceIfPossible(targetClass);
        CglibUtil.copy(source2, target, converter);
        return target;
    }

    public static void copy(Object source2, Object target) {
        CglibUtil.copy(source2, target, null);
    }

    public static void copy(Object source2, Object target, Converter converter) {
        Assert.notNull(source2, "Source bean must be not null.", new Object[0]);
        Assert.notNull(target, "Target bean must be not null.", new Object[0]);
        Class<?> sourceClass = source2.getClass();
        Class<?> targetClass = target.getClass();
        BeanCopier beanCopier = BeanCopierCache.INSTANCE.get(sourceClass, targetClass, converter);
        beanCopier.copy(source2, target, converter);
    }

    public static <S, T> List<T> copyList(Collection<S> source2, Supplier<T> target) {
        return CglibUtil.copyList(source2, target, null, null);
    }

    public static <S, T> List<T> copyList(Collection<S> source2, Supplier<T> target, Converter converter) {
        return CglibUtil.copyList(source2, target, converter, null);
    }

    public static <S, T> List<T> copyList(Collection<S> source2, Supplier<T> target, BiConsumer<S, T> callback) {
        return CglibUtil.copyList(source2, target, null, callback);
    }

    public static <S, T> List<T> copyList(Collection<S> source2, Supplier<T> target, Converter converter, BiConsumer<S, T> callback) {
        return source2.stream().map(s -> {
            Object t = target.get();
            CglibUtil.copy(s, t, converter);
            if (callback != null) {
                callback.accept(s, t);
            }
            return t;
        }).collect(Collectors.toList());
    }

    public static BeanMap toMap(Object bean2) {
        return BeanMap.create((Object)bean2);
    }

    public static <T> T fillBean(Map map2, T bean2) {
        BeanMap.create(bean2).putAll(map2);
        return bean2;
    }

    public static <T> T toBean(Map map2, Class<T> beanClass) {
        return CglibUtil.fillBean(map2, ReflectUtil.newInstanceIfPossible(beanClass));
    }
}

