/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface SymmetricEncryptor {
    public byte[] encrypt(byte[] var1);

    public void encrypt(InputStream var1, OutputStream var2, boolean var3);

    default public String encryptHex(byte[] data2) {
        return HexUtil.encodeHexStr(this.encrypt(data2));
    }

    default public String encryptBase64(byte[] data2) {
        return Base64.encode(this.encrypt(data2));
    }

    default public byte[] encrypt(String data2, String charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data2, charset));
    }

    default public byte[] encrypt(String data2, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data2, charset));
    }

    default public String encryptHex(String data2, String charset) {
        return HexUtil.encodeHexStr(this.encrypt(data2, charset));
    }

    default public String encryptHex(String data2, Charset charset) {
        return HexUtil.encodeHexStr(this.encrypt(data2, charset));
    }

    default public String encryptBase64(String data2, String charset) {
        return Base64.encode(this.encrypt(data2, charset));
    }

    default public String encryptBase64(String data2, Charset charset) {
        return Base64.encode(this.encrypt(data2, charset));
    }

    default public byte[] encrypt(String data2) {
        return this.encrypt(StrUtil.bytes((CharSequence)data2, CharsetUtil.CHARSET_UTF_8));
    }

    default public String encryptHex(String data2) {
        return HexUtil.encodeHexStr(this.encrypt(data2));
    }

    default public String encryptBase64(String data2) {
        return Base64.encode(this.encrypt(data2));
    }

    default public byte[] encrypt(InputStream data2) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data2));
    }

    default public String encryptHex(InputStream data2) {
        return HexUtil.encodeHexStr(this.encrypt(data2));
    }

    default public String encryptBase64(InputStream data2) {
        return Base64.encode(this.encrypt(data2));
    }
}

