/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface SymmetricDecryptor {
    public byte[] decrypt(byte[] var1);

    public void decrypt(InputStream var1, OutputStream var2, boolean var3);

    default public String decryptStr(byte[] bytes2, Charset charset) {
        return StrUtil.str(this.decrypt(bytes2), charset);
    }

    default public String decryptStr(byte[] bytes2) {
        return this.decryptStr(bytes2, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decrypt(String data2) {
        return this.decrypt(SecureUtil.decode(data2));
    }

    default public String decryptStr(String data2, Charset charset) {
        return StrUtil.str(this.decrypt(data2), charset);
    }

    default public String decryptStr(String data2) {
        return this.decryptStr(data2, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decrypt(InputStream data2) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data2));
    }

    default public String decryptStr(InputStream data2, Charset charset) {
        return StrUtil.str(this.decrypt(data2), charset);
    }

    default public String decryptStr(InputStream data2) {
        return this.decryptStr(data2, CharsetUtil.CHARSET_UTF_8);
    }
}

