/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class DES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public DES() {
        super(SymmetricAlgorithm.DES);
    }

    public DES(byte[] key2) {
        super(SymmetricAlgorithm.DES, key2);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key2) {
        this(mode, padding, key2, null);
    }

    public DES(Mode mode, Padding padding, byte[] key2, byte[] iv) {
        this(mode.name(), padding.name(), key2, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key2) {
        this(mode, padding, key2, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key2, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key2, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key2) {
        this(mode, padding, SecureUtil.generateKey("DES", key2), null);
    }

    public DES(String mode, String padding, byte[] key2, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey("DES", key2), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key2) {
        this(mode, padding, key2, null);
    }

    public DES(String mode, String padding, SecretKey key2, IvParameterSpec iv) {
        super(StrUtil.format("DES/{}/{}", mode, padding), key2, iv);
    }
}

