/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.symmetric;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES
extends SymmetricCrypto {
    private static final long serialVersionUID = 1L;

    public AES() {
        super(SymmetricAlgorithm.AES);
    }

    public AES(byte[] key2) {
        super(SymmetricAlgorithm.AES, key2);
    }

    public AES(SecretKey key2) {
        super(SymmetricAlgorithm.AES, key2);
    }

    public AES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public AES(Mode mode, Padding padding, byte[] key2) {
        this(mode, padding, key2, null);
    }

    public AES(Mode mode, Padding padding, byte[] key2, byte[] iv) {
        this(mode.name(), padding.name(), key2, iv);
    }

    public AES(Mode mode, Padding padding, SecretKey key2) {
        this(mode, padding, key2, (AlgorithmParameterSpec)null);
    }

    public AES(Mode mode, Padding padding, SecretKey key2, byte[] iv) {
        this(mode, padding, key2, (AlgorithmParameterSpec)(ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv)));
    }

    public AES(Mode mode, Padding padding, SecretKey key2, AlgorithmParameterSpec paramsSpec) {
        this(mode.name(), padding.name(), key2, paramsSpec);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key2) {
        this(mode, padding, key2, null);
    }

    public AES(String mode, String padding, byte[] key2, byte[] iv) {
        this(mode, padding, KeyUtil.generateKey(SymmetricAlgorithm.AES.getValue(), key2), (AlgorithmParameterSpec)(ArrayUtil.isEmpty(iv) ? null : new IvParameterSpec(iv)));
    }

    public AES(String mode, String padding, SecretKey key2) {
        this(mode, padding, key2, null);
    }

    public AES(String mode, String padding, SecretKey key2, AlgorithmParameterSpec paramsSpec) {
        super(StrUtil.format("AES/{}/{}", mode, padding), key2, paramsSpec);
    }
}

