/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.otp;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.otp.HOTP;
import java.time.Duration;
import java.time.Instant;

public class TOTP
extends HOTP {
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    private final Duration timeStep;

    public TOTP(byte[] key2) {
        this(DEFAULT_TIME_STEP, key2);
    }

    public TOTP(Duration timeStep, byte[] key2) {
        this(timeStep, 6, key2);
    }

    public TOTP(Duration timeStep, int passwordLength, byte[] key2) {
        this(timeStep, passwordLength, HOTP_HMAC_ALGORITHM, key2);
    }

    public TOTP(Duration timeStep, int passwordLength, HmacAlgorithm algorithm, byte[] key2) {
        super(passwordLength, algorithm, key2);
        this.timeStep = timeStep;
    }

    public int generate(Instant timestamp) {
        return this.generate(timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public boolean validate(Instant timestamp, int offsetSize, int code) {
        if (offsetSize == 0) {
            return this.generate(timestamp) == code;
        }
        for (int i = -offsetSize; i <= offsetSize; ++i) {
            if (this.generate(timestamp.plus(this.getTimeStep().multipliedBy(i))) != code) continue;
            return true;
        }
        return false;
    }

    public static String generateGoogleSecretKey(String account, int numBytes) {
        return StrUtil.format("otpauth://totp/{}?secret={}", account, TOTP.generateSecretKey(numBytes));
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

