/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest.mac;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.mac.MacEngine;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DefaultHMacEngine
implements MacEngine {
    private Mac mac;

    public DefaultHMacEngine(String algorithm, byte[] key2) {
        this(algorithm, null == key2 ? null : new SecretKeySpec(key2, algorithm));
    }

    public DefaultHMacEngine(String algorithm, Key key2) {
        this(algorithm, key2, null);
    }

    public DefaultHMacEngine(String algorithm, Key key2, AlgorithmParameterSpec spec) {
        this.init(algorithm, key2, spec);
    }

    public DefaultHMacEngine init(String algorithm, byte[] key2) {
        return this.init(algorithm, null == key2 ? null : new SecretKeySpec(key2, algorithm));
    }

    public DefaultHMacEngine init(String algorithm, Key key2) {
        return this.init(algorithm, key2, null);
    }

    public DefaultHMacEngine init(String algorithm, Key key2, AlgorithmParameterSpec spec) {
        try {
            this.mac = SecureUtil.createMac(algorithm);
            if (null == key2) {
                key2 = SecureUtil.generateKey(algorithm);
            }
            if (null != spec) {
                this.mac.init(key2, spec);
            } else {
                this.mac.init(key2);
            }
        }
        catch (Exception e2) {
            throw new CryptoException(e2);
        }
        return this;
    }

    public Mac getMac() {
        return this.mac;
    }

    @Override
    public void update(byte[] in) {
        this.mac.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.mac.update(in, inOff, len);
    }

    @Override
    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    @Override
    public void reset() {
        this.mac.reset();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public String getAlgorithm() {
        return this.mac.getAlgorithm();
    }
}

