/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.digest;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class Digester
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MessageDigest digest;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public Digester(DigestAlgorithm algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this(algorithm, null);
    }

    public Digester(DigestAlgorithm algorithm, Provider provider) {
        this.init(algorithm.getValue(), provider);
    }

    public Digester(String algorithm, Provider provider) {
        this.init(algorithm, provider);
    }

    public Digester init(String algorithm, Provider provider) {
        if (null == provider) {
            this.digest = SecureUtil.createMessageDigest(algorithm);
        } else {
            try {
                this.digest = MessageDigest.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new CryptoException(e2);
            }
        }
        return this;
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        this.digest.reset();
        return this;
    }

    public byte[] digest(String data2, String charsetName) {
        return this.digest(data2, CharsetUtil.charset(charsetName));
    }

    public byte[] digest(String data2, Charset charset) {
        return this.digest(StrUtil.bytes((CharSequence)data2, charset));
    }

    public byte[] digest(String data2) {
        return this.digest(data2, CharsetUtil.CHARSET_UTF_8);
    }

    public String digestHex(String data2, String charsetName) {
        return this.digestHex(data2, CharsetUtil.charset(charsetName));
    }

    public String digestHex(String data2, Charset charset) {
        return HexUtil.encodeHexStr(this.digest(data2, charset));
    }

    public String digestHex(String data2) {
        return this.digestHex(data2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file2) throws CryptoException {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file2);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public String digestHex(File file2) {
        return HexUtil.encodeHexStr(this.digest(file2));
    }

    public byte[] digest(byte[] data2) {
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data2);
        } else if (this.saltPosition >= data2.length) {
            result = this.doDigest(data2, this.salt);
        } else if (ArrayUtil.isNotEmpty(this.salt)) {
            this.digest.update(data2, 0, this.saltPosition);
            this.digest.update(this.salt);
            this.digest.update(data2, this.saltPosition, data2.length - this.saltPosition);
            result = this.digest.digest();
        } else {
            result = this.doDigest(new byte[][]{data2});
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(byte[] data2) {
        return HexUtil.encodeHexStr(this.digest(data2));
    }

    public byte[] digest(InputStream data2) {
        return this.digest(data2, 8192);
    }

    public String digestHex(InputStream data2) {
        return HexUtil.encodeHexStr(this.digest(data2));
    }

    public byte[] digest(InputStream data2, int bufferLength) throws IORuntimeException {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        try {
            result = ArrayUtil.isEmpty(this.salt) ? this.digestWithoutSalt(data2, bufferLength) : this.digestWithSalt(data2, bufferLength);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(InputStream data2, int bufferLength) {
        return HexUtil.encodeHexStr(this.digest(data2, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public int getDigestLength() {
        return this.digest.getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data2, int bufferLength) throws IOException {
        int read2;
        byte[] buffer = new byte[bufferLength];
        while ((read2 = data2.read(buffer, 0, bufferLength)) > -1) {
            this.digest.update(buffer, 0, read2);
        }
        return this.digest.digest();
    }

    private byte[] digestWithSalt(InputStream data2, int bufferLength) throws IOException {
        int read2;
        if (this.saltPosition <= 0) {
            this.digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read2 = data2.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read2) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    this.digest.update(buffer, 0, total - this.saltPosition);
                }
                this.digest.update(this.salt);
                this.digest.update(buffer, total - this.saltPosition, read2);
                continue;
            }
            this.digest.update(buffer, 0, read2);
        }
        if (total < this.saltPosition) {
            this.digest.update(this.salt);
        }
        return this.digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        for (byte[] data2 : datas) {
            if (null == data2) continue;
            this.digest.update(data2);
        }
        return this.digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

