/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;

public class Sign
extends BaseAsymmetric<Sign> {
    private static final long serialVersionUID = 1L;
    protected Signature signature;

    public Sign(SignAlgorithm algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(String algorithm) {
        this(algorithm, null, (byte[])null);
    }

    public Sign(SignAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public Sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(SignAlgorithm algorithm, KeyPair keyPair) {
        this(algorithm.getValue(), keyPair);
    }

    public Sign(SignAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public Sign(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public Sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, SecureUtil.generatePrivateKey(algorithm, privateKey), SecureUtil.generatePublicKey(algorithm, publicKey));
    }

    public Sign(String algorithm, KeyPair keyPair) {
        this(algorithm, keyPair.getPrivate(), keyPair.getPublic());
    }

    public Sign(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    @Override
    public Sign init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this.signature = SecureUtil.createSignature(algorithm);
        super.init(algorithm, privateKey, publicKey);
        return this;
    }

    public Sign setParameter(AlgorithmParameterSpec params) {
        try {
            this.signature.setParameter(params);
        }
        catch (InvalidAlgorithmParameterException e2) {
            throw new CryptoException(e2);
        }
        return this;
    }

    public byte[] sign(String data2, Charset charset) {
        return this.sign(StrUtil.bytes((CharSequence)data2, charset));
    }

    public byte[] sign(String data2) {
        return this.sign(data2, CharsetUtil.CHARSET_UTF_8);
    }

    public String signHex(String data2, Charset charset) {
        return HexUtil.encodeHexStr(this.sign(data2, charset));
    }

    public String signHex(String data2) {
        return this.signHex(data2, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] sign(byte[] data2) {
        return this.sign(new ByteArrayInputStream(data2), -1);
    }

    public String signHex(byte[] data2) {
        return HexUtil.encodeHexStr(this.sign(data2));
    }

    public String signHex(InputStream data2) {
        return HexUtil.encodeHexStr(this.sign(data2));
    }

    public byte[] sign(InputStream data2) {
        return this.sign(data2, 8192);
    }

    public String digestHex(InputStream data2, int bufferLength) {
        return HexUtil.encodeHexStr(this.sign(data2, bufferLength));
    }

    public byte[] sign(InputStream data2, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        this.lock.lock();
        try {
            byte[] result;
            this.signature.initSign(this.privateKey);
            try {
                int read2 = data2.read(buffer, 0, bufferLength);
                while (read2 > -1) {
                    this.signature.update(buffer, 0, read2);
                    read2 = data2.read(buffer, 0, bufferLength);
                }
                result = this.signature.sign();
            }
            catch (Exception e2) {
                throw new CryptoException(e2);
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e3) {
            throw new CryptoException(e3);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data2, byte[] sign) {
        this.lock.lock();
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(data2);
            boolean bl = this.signature.verify(sign);
            return bl;
        }
        catch (Exception e2) {
            throw new CryptoException(e2);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Sign setSignature(Signature signature) {
        this.signature = signature;
        return this;
    }

    public Sign setCertificate(Certificate certificate) {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && CollUtil.isNotEmpty(critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) && critSet.contains("2.5.29.15") && (keyUsageInfo = cert.getKeyUsage()) != null && !keyUsageInfo[0]) {
            throw new CryptoException("Wrong key usage");
        }
        this.publicKey = certificate.getPublicKey();
        return this;
    }
}

