/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricEncryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data2, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data2, keyType));
    }

    default public String encryptBase64(byte[] data2, KeyType keyType) {
        return Base64.encode(this.encrypt(data2, keyType));
    }

    default public byte[] encrypt(String data2, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data2, charset), keyType);
    }

    default public byte[] encrypt(String data2, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data2, charset), keyType);
    }

    default public byte[] encrypt(String data2, KeyType keyType) {
        return this.encrypt(StrUtil.utf8Bytes(data2), keyType);
    }

    default public String encryptHex(String data2, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data2, keyType));
    }

    default public String encryptHex(String data2, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data2, charset, keyType));
    }

    default public String encryptBase64(String data2, KeyType keyType) {
        return Base64.encode(this.encrypt(data2, keyType));
    }

    default public String encryptBase64(String data2, Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data2, charset, keyType));
    }

    default public byte[] encrypt(InputStream data2, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data2), keyType);
    }

    default public String encryptHex(InputStream data2, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data2, keyType));
    }

    default public String encryptBase64(InputStream data2, KeyType keyType) {
        return Base64.encode(this.encrypt(data2, keyType));
    }

    default public String encryptBcd(String data2, KeyType keyType) {
        return this.encryptBcd(data2, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public String encryptBcd(String data2, KeyType keyType, Charset charset) {
        return BCD.bcdToStr(this.encrypt(data2, charset, keyType));
    }
}

