/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricDecryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data2, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data2), keyType);
    }

    default public byte[] decrypt(String data2, KeyType keyType) {
        return this.decrypt(SecureUtil.decode(data2), keyType);
    }

    default public String decryptStr(String data2, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decrypt(data2, keyType), charset);
    }

    default public String decryptStr(String data2, KeyType keyType) {
        return this.decryptStr(data2, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data2, KeyType keyType) {
        return this.decryptFromBcd(data2, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data2, KeyType keyType, Charset charset) {
        Assert.notNull(data2, "Bcd string must be not null!", new Object[0]);
        byte[] dataBytes = BCD.ascToBcd(StrUtil.bytes((CharSequence)data2, charset));
        return this.decrypt(dataBytes, keyType);
    }

    default public String decryptStrFromBcd(String data2, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decryptFromBcd(data2, keyType, charset), charset);
    }

    default public String decryptStrFromBcd(String data2, KeyType keyType) {
        return this.decryptStrFromBcd(data2, keyType, CharsetUtil.CHARSET_UTF_8);
    }
}

