/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class AsymmetricCrypto
extends AbstractAsymmetricCrypto<AsymmetricCrypto> {
    private static final long serialVersionUID = 1L;
    protected Cipher cipher;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;
    private AlgorithmParameterSpec algorithmParameterSpec;

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, KeyUtil.generatePrivateKey(algorithm, privateKey), KeyUtil.generatePublicKey(algorithm, publicKey));
    }

    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super.init(algorithm, privateKey, publicKey);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data2, KeyType keyType) {
        Key key2 = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.initMode(1, key2);
            if (this.encryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data2, this.encryptBlockSize < 0 ? data2.length : this.encryptBlockSize);
            return blockSize22;
        }
        catch (Exception e2) {
            throw new CryptoException(e2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data2, KeyType keyType) {
        Key key2 = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize22;
            this.initMode(2, key2);
            if (this.decryptBlockSize < 0 && (blockSize22 = this.cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data2, this.decryptBlockSize < 0 ? data2.length : this.decryptBlockSize);
            return blockSize22;
        }
        catch (Exception e2) {
            throw new CryptoException(e2);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    protected void initCipher() {
        this.cipher = SecureUtil.createCipher(this.algorithm);
    }

    private byte[] doFinal(byte[] data2, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data2.length;
        if (dataLength <= maxBlockSize) {
            return this.cipher.doFinal(data2, 0, dataLength);
        }
        return this.doFinalWithBlock(data2, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data2, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data2.length;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.cipher.doFinal(data2, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }

    private void initMode(int mode, Key key2) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (null != this.algorithmParameterSpec) {
            this.cipher.init(mode, key2, this.algorithmParameterSpec);
        } else {
            this.cipher.init(mode, key2);
        }
    }
}

