/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.KeyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtil {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return (PrivateKey)PemUtil.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return (PublicKey)PemUtil.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) {
        PemObject object = PemUtil.readPemObject(keyStream);
        String type2 = object.getType();
        if (StrUtil.isNotBlank(type2)) {
            if (type2.endsWith("EC PRIVATE KEY")) {
                return KeyUtil.generatePrivateKey("EC", object.getContent());
            }
            if (type2.endsWith("PRIVATE KEY")) {
                return KeyUtil.generateRSAPrivateKey(object.getContent());
            }
            if (type2.endsWith("EC PUBLIC KEY")) {
                return KeyUtil.generatePublicKey("EC", object.getContent());
            }
            if (type2.endsWith("PUBLIC KEY")) {
                return KeyUtil.generateRSAPublicKey(object.getContent());
            }
            if (type2.endsWith("CERTIFICATE")) {
                return KeyUtil.readPublicKeyFromCert(IoUtil.toStream(object.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) {
        PemObject pemObject = PemUtil.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return PemUtil.readPemObject(IoUtil.getUtf8Reader(keyStream));
    }

    public static PemObject readPemObject(Reader reader2) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader2);
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e2) {
            try {
                throw new IORuntimeException(e2);
            }
            catch (Throwable throwable) {
                IoUtil.close(pemReader);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)pemReader);
        return pemObject;
    }

    public static PrivateKey readSm2PemPrivateKey(InputStream keyStream) {
        try {
            PrivateKey privateKey = KeyUtil.generatePrivateKey("sm2", ECKeyUtil.createOpenSSHPrivateKeySpec(PemUtil.readPem(keyStream)));
            return privateKey;
        }
        finally {
            IoUtil.close(keyStream);
        }
    }

    public static String toPem(String type2, byte[] content) {
        StringWriter stringWriter = new StringWriter();
        PemUtil.writePemObject(type2, content, stringWriter);
        return stringWriter.toString();
    }

    public static void writePemObject(String type2, byte[] content, OutputStream keyStream) {
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(type2, content), keyStream);
    }

    public static void writePemObject(String type2, byte[] content, Writer writer2) {
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(type2, content), writer2);
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        PemUtil.writePemObject(pemObject, IoUtil.getUtf8Writer(keyStream));
    }

    public static void writePemObject(PemObjectGenerator pemObject, Writer writer2) {
        PemWriter pemWriter = new PemWriter(writer2);
        try {
            pemWriter.writeObject(pemObject);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close((Closeable)pemWriter);
        }
    }
}

