/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.cron.pattern.CronPattern;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronPatternUtil {
    public static Date nextDateAfter(CronPattern pattern, Date start, boolean isMatchSecond) {
        List<Date> matchedDates = CronPatternUtil.matchedDates(pattern, start.getTime(), DateUtil.endOfYear(start).getTime(), 1, isMatchSecond);
        if (CollUtil.isNotEmpty(matchedDates)) {
            return matchedDates.get(0);
        }
        return null;
    }

    public static List<Date> matchedDates(String patternStr, Date start, int count2, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start, DateUtil.endOfYear(start), count2, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count2, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start.getTime(), end.getTime(), count2, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count2, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(new CronPattern(patternStr), start, end, count2, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count2, boolean isMatchSecond) {
        Assert.isTrue(start < end, "Start date is later than end !", new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count2);
        long step = isMatchSecond ? DateUnit.SECOND.getMillis() : DateUnit.MINUTE.getMillis();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add(DateUtil.date(i));
            if (result.size() >= count2) break;
        }
        return result;
    }
}

