/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final String COMMENT_REGEX = "(?s)<!--.+?-->";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;
    private static SAXParserFactory factory;

    public static synchronized void disableDefaultDocumentBuilderFactory() {
        defaultDocumentBuilderFactory = null;
    }

    public static synchronized void setNamespaceAware(boolean isNamespaceAware) {
        namespaceAware = isNamespaceAware;
    }

    public static Document readXML(File file2) {
        Assert.notNull(file2, "Xml file is null !", new Object[0]);
        if (!file2.exists()) {
            throw new UtilException("File [{}] not a exist!", file2.getAbsolutePath());
        }
        if (!file2.isFile()) {
            throw new UtilException("[{}] not a file!", file2.getAbsolutePath());
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file2);
            Document document = XmlUtil.readXML(in);
            return document;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static Document readXML(String pathOrContent) {
        if (StrUtil.startWith((CharSequence)pathOrContent, '<')) {
            return XmlUtil.parseXml(pathOrContent);
        }
        return XmlUtil.readXML(FileUtil.file(pathOrContent));
    }

    public static Document readXML(InputStream inputStream) throws UtilException {
        return XmlUtil.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader2) throws UtilException {
        return XmlUtil.readXML(new InputSource(reader2));
    }

    public static Document readXML(InputSource source2) {
        DocumentBuilder builder = XmlUtil.createDocumentBuilder();
        try {
            return builder.parse(source2);
        }
        catch (Exception e2) {
            throw new UtilException(e2, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static void readBySax(File file2, ContentHandler contentHandler) {
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file2);
            XmlUtil.readBySax(new InputSource(in), contentHandler);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static void readBySax(Reader reader2, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(reader2), contentHandler);
        }
        finally {
            IoUtil.close(reader2);
        }
    }

    public static void readBySax(InputStream source2, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(source2), contentHandler);
        }
        finally {
            IoUtil.close(source2);
        }
    }

    public static void readBySax(InputSource source2, ContentHandler contentHandler) {
        if (null == factory) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(namespaceAware);
        }
        try {
            SAXParser parse2 = factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse2.parse(source2, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader2 = parse2.getXMLReader();
            reader2.setContentHandler(contentHandler);
            reader2.parse(source2);
        }
        catch (ParserConfigurationException | SAXException e2) {
            throw new UtilException(e2);
        }
        catch (IOException e3) {
            throw new IORuntimeException(e3);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (StrUtil.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        xmlStr = XmlUtil.cleanInvalid(xmlStr);
        return XmlUtil.readXML(StrUtil.getReader(xmlStr));
    }

    public static <T> T readObjectFromXml(File source2) {
        return XmlUtil.readObjectFromXml(new InputSource(FileUtil.getInputStream(source2)));
    }

    public static <T> T readObjectFromXml(String xmlStr) {
        return XmlUtil.readObjectFromXml(new InputSource(StrUtil.getReader(xmlStr)));
    }

    public static <T> T readObjectFromXml(InputSource source2) {
        Object result;
        XMLDecoder xmldec = null;
        try {
            xmldec = new XMLDecoder(source2);
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.close(xmldec);
            throw throwable;
        }
        IoUtil.close(xmldec);
        return (T)result;
    }

    public static String toStr(Node doc2) {
        return XmlUtil.toStr(doc2, false);
    }

    public static String toStr(Document doc2) {
        return XmlUtil.toStr((Node)doc2);
    }

    public static String toStr(Node doc2, boolean isPretty) {
        return XmlUtil.toStr(doc2, "UTF-8", isPretty);
    }

    public static String toStr(Document doc2, boolean isPretty) {
        return XmlUtil.toStr((Node)doc2, isPretty);
    }

    public static String toStr(Node doc2, String charset, boolean isPretty) {
        return XmlUtil.toStr(doc2, charset, isPretty, false);
    }

    public static String toStr(Document doc2, String charset, boolean isPretty) {
        return XmlUtil.toStr((Node)doc2, charset, isPretty);
    }

    public static String toStr(Node doc2, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer2 = StrUtil.getWriter();
        try {
            XmlUtil.write(doc2, writer2, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        }
        catch (Exception e2) {
            throw new UtilException(e2, "Trans xml document to string error!", new Object[0]);
        }
        return writer2.toString();
    }

    public static String format(Document doc2) {
        return XmlUtil.toStr(doc2, true);
    }

    public static String format(String xmlStr) {
        return XmlUtil.format(XmlUtil.parseXml(xmlStr));
    }

    public static void toFile(Document doc2, String absolutePath) {
        XmlUtil.toFile(doc2, absolutePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document doc2, String path2, String charset) {
        if (StrUtil.isBlank(charset)) {
            charset = doc2.getXmlEncoding();
        }
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer2 = null;
        try {
            writer2 = FileUtil.getWriter(path2, charset, false);
            XmlUtil.write((Node)doc2, writer2, charset, 2);
        }
        catch (Throwable throwable) {
            IoUtil.close(writer2);
            throw throwable;
        }
        IoUtil.close(writer2);
    }

    public static void write(Node node2, Writer writer2, String charset, int indent2) {
        XmlUtil.transform(new DOMSource(node2), new StreamResult(writer2), charset, indent2);
    }

    public static void write(Node node2, Writer writer2, String charset, int indent2, boolean omitXmlDeclaration) {
        XmlUtil.transform(new DOMSource(node2), new StreamResult(writer2), charset, indent2, omitXmlDeclaration);
    }

    public static void write(Node node2, OutputStream out, String charset, int indent2) {
        XmlUtil.transform(new DOMSource(node2), new StreamResult(out), charset, indent2);
    }

    public static void write(Node node2, OutputStream out, String charset, int indent2, boolean omitXmlDeclaration) {
        XmlUtil.transform(new DOMSource(node2), new StreamResult(out), charset, indent2, omitXmlDeclaration);
    }

    public static void transform(Source source2, Result result, String charset, int indent2) {
        XmlUtil.transform(source2, result, charset, indent2, false);
    }

    public static void transform(Source source2, Result result, String charset, int indent2, boolean omitXmlDeclaration) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer xformer = factory.newTransformer();
            if (indent2 > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent2));
            }
            if (StrUtil.isNotBlank(charset)) {
                xformer.setOutputProperty("encoding", charset);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source2, result);
        }
        catch (Exception e2) {
            throw new UtilException(e2, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static Document createXml() {
        return XmlUtil.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        try {
            builder = XmlUtil.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e2) {
            throw new UtilException(e2, "Create xml document error!", new Object[0]);
        }
        return builder;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = StrUtil.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        return XmlUtil.disableXXE(factory);
    }

    public static Document createXml(String rootElementName) {
        return XmlUtil.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace2) {
        Document doc2 = XmlUtil.createXml();
        doc2.appendChild(null == namespace2 ? doc2.createElement(rootElementName) : doc2.createElementNS(namespace2, rootElementName));
        return doc2;
    }

    public static Element getRootElement(Document doc2) {
        return null == doc2 ? null : doc2.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node2) {
        return node2 instanceof Document ? (Document)node2 : node2.getOwnerDocument();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static String cleanComment(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(COMMENT_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = StrUtil.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlUtil.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node2 = nodeList.item(i);
            if (1 != node2.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static void writeObjectAsXml(File dest, Object bean2) {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(FileUtil.getOutputStream(dest));
            xmlenc.writeObject(bean2);
        }
        catch (Throwable throwable) {
            IoUtil.close(xmlenc);
            throw throwable;
        }
        IoUtil.close(xmlenc);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Element getElementByXPath(String expression, Object source2) {
        return (Element)XmlUtil.getNodeByXPath(expression, source2);
    }

    public static NodeList getNodeListByXPath(String expression, Object source2) {
        return (NodeList)XmlUtil.getByXPath(expression, source2, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String expression, Object source2) {
        return (Node)XmlUtil.getByXPath(expression, source2, XPathConstants.NODE);
    }

    public static Object getByXPath(String expression, Object source2, QName returnType) {
        UniversalNamespaceCache nsContext = null;
        if (source2 instanceof Node) {
            nsContext = new UniversalNamespaceCache((Node)source2, false);
        }
        return XmlUtil.getByXPath(expression, source2, returnType, nsContext);
    }

    public static Object getByXPath(String expression, Object source2, QName returnType, NamespaceContext nsContext) {
        XPath xPath = XmlUtil.createXPath();
        if (null != nsContext) {
            xPath.setNamespaceContext(nsContext);
        }
        try {
            if (source2 instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source2, returnType);
            }
            return xPath.evaluate(expression, source2, returnType);
        }
        catch (XPathExpressionException e2) {
            throw new UtilException(e2);
        }
    }

    public static String escape(String string2) {
        return EscapeUtil.escapeHtml4(string2);
    }

    public static String unescape(String string2) {
        return EscapeUtil.unescapeHtml4(string2);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlUtil.xmlToMap(xmlStr, new HashMap<String, Object>());
    }

    public static <T> T xmlToBean(Node node2, Class<T> bean2) {
        String simpleName;
        Map<String, Object> map2 = XmlUtil.xmlToMap(node2);
        if (null != map2 && map2.size() == 1 && map2.containsKey(simpleName = bean2.getSimpleName())) {
            return BeanUtil.toBean(map2.get(simpleName), bean2);
        }
        return BeanUtil.toBean(map2, bean2);
    }

    public static Map<String, Object> xmlToMap(Node node2) {
        return XmlUtil.xmlToMap(node2, new HashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        Document doc2 = XmlUtil.parseXml(xmlStr);
        Element root2 = XmlUtil.getRootElement(doc2);
        root2.normalize();
        return XmlUtil.xmlToMap(root2, result);
    }

    public static Map<String, Object> xmlToMap(Node node2, Map<String, Object> result) {
        if (null == result) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node2.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Map<String, Object> map2;
            Node childNode = nodeList.item(i);
            if (!XmlUtil.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            Object value = result.get(childEle.getNodeName());
            Object newValue = childEle.hasChildNodes() ? (MapUtil.isNotEmpty(map2 = XmlUtil.xmlToMap(childEle)) ? map2 : childEle.getTextContent()) : childEle.getTextContent();
            if (null == newValue) continue;
            if (null != value) {
                if (value instanceof List) {
                    ((List)value).add(newValue);
                    continue;
                }
                result.put(childEle.getNodeName(), CollUtil.newArrayList(value, newValue));
                continue;
            }
            result.put(childEle.getNodeName(), newValue);
        }
        return result;
    }

    public static String mapToXmlStr(Map<?, ?> data2) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, "xml"));
    }

    public static String mapToXmlStr(Map<?, ?> data2, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, "xml"), "UTF-8", false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data2, String rootName) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, rootName));
    }

    public static String mapToXmlStr(Map<?, ?> data2, String rootName, String namespace2) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, rootName, namespace2));
    }

    public static String mapToXmlStr(Map<?, ?> data2, String rootName, String namespace2, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, rootName, namespace2), "UTF-8", false, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data2, String rootName, String namespace2, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, rootName, namespace2), "UTF-8", isPretty, omitXmlDeclaration);
    }

    public static String mapToXmlStr(Map<?, ?> data2, String rootName, String namespace2, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data2, rootName, namespace2), charset, isPretty, omitXmlDeclaration);
    }

    public static Document mapToXml(Map<?, ?> data2, String rootName) {
        return XmlUtil.mapToXml(data2, rootName, null);
    }

    public static Document mapToXml(Map<?, ?> data2, String rootName, String namespace2) {
        Document doc2 = XmlUtil.createXml();
        Element root2 = XmlUtil.appendChild(doc2, rootName, namespace2);
        XmlUtil.appendMap(doc2, root2, data2);
        return doc2;
    }

    public static Document beanToXml(Object bean2) {
        return XmlUtil.beanToXml(bean2, null);
    }

    public static Document beanToXml(Object bean2, String namespace2) {
        return XmlUtil.beanToXml(bean2, namespace2, false);
    }

    public static Document beanToXml(Object bean2, String namespace2, boolean ignoreNull) {
        if (null == bean2) {
            return null;
        }
        return XmlUtil.mapToXml(BeanUtil.beanToMap(bean2, false, ignoreNull), bean2.getClass().getSimpleName(), namespace2);
    }

    public static boolean isElement(Node node2) {
        return null != node2 && 1 == node2.getNodeType();
    }

    public static Element appendChild(Node node2, String tagName) {
        return XmlUtil.appendChild(node2, tagName, null);
    }

    public static Element appendChild(Node node2, String tagName, String namespace2) {
        Document doc2 = XmlUtil.getOwnerDocument(node2);
        Element child = null == namespace2 ? doc2.createElement(tagName) : doc2.createElementNS(namespace2, tagName);
        node2.appendChild(child);
        return child;
    }

    public static Node appendText(Node node2, CharSequence text) {
        return XmlUtil.appendText(XmlUtil.getOwnerDocument(node2), node2, text);
    }

    public static void append(Node node2, Object data2) {
        XmlUtil.append(XmlUtil.getOwnerDocument(node2), node2, data2);
    }

    private static void append(Document doc2, Node node2, Object data2) {
        if (data2 instanceof Map) {
            XmlUtil.appendMap(doc2, node2, (Map)data2);
        } else if (data2 instanceof Iterator) {
            XmlUtil.appendIterator(doc2, node2, (Iterator)data2);
        } else if (data2 instanceof Iterable) {
            XmlUtil.appendIterator(doc2, node2, ((Iterable)data2).iterator());
        } else {
            XmlUtil.appendText(doc2, node2, data2.toString());
        }
    }

    private static void appendMap(Document doc2, Node node2, Map data2) {
        data2.forEach((key2, value) -> {
            if (null != key2) {
                Element child = XmlUtil.appendChild(node2, key2.toString());
                if (null != value) {
                    XmlUtil.append(doc2, child, value);
                }
            }
        });
    }

    private static void appendIterator(Document doc2, Node node2, Iterator data2) {
        Node parentNode = node2.getParentNode();
        boolean isFirst = true;
        while (data2.hasNext()) {
            Object eleData = data2.next();
            if (isFirst) {
                XmlUtil.append(doc2, node2, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node2.cloneNode(false);
            parentNode.appendChild(cloneNode);
            XmlUtil.append(doc2, cloneNode, eleData);
        }
    }

    private static Node appendText(Document doc2, Node node2, CharSequence text) {
        return node2.appendChild(doc2.createTextNode(StrUtil.str(text)));
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        try {
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(feature, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return dbf;
    }

    public static class UniversalNamespaceCache
    implements NamespaceContext {
        private static final String DEFAULT_NS = "DEFAULT";
        private final BiMap<String, String> prefixUri = new BiMap(new HashMap());

        public UniversalNamespaceCache(Node node2, boolean toplevelOnly) {
            this.examineNode(node2.getFirstChild(), toplevelOnly);
        }

        private void examineNode(Node node2, boolean attributesOnly) {
            NodeList childNodes;
            NamedNodeMap attributes = node2.getAttributes();
            if (null != attributes) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    this.storeAttribute(attribute);
                }
            }
            if (!attributesOnly && null != (childNodes = node2.getChildNodes())) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node item = childNodes.item(i);
                    if (item.getNodeType() != 1) continue;
                    this.examineNode(item, false);
                }
            }
        }

        private void storeAttribute(Node attribute) {
            if (null == attribute) {
                return;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                if ("xmlns".equals(attribute.getNodeName())) {
                    this.prefixUri.put(DEFAULT_NS, attribute.getNodeValue());
                } else {
                    this.prefixUri.put(attribute.getLocalName(), attribute.getNodeValue());
                }
            }
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null || "".equals(prefix)) {
                return (String)this.prefixUri.get(DEFAULT_NS);
            }
            return (String)this.prefixUri.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.prefixUri.getInverse().get(namespaceURI);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

