/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.text.TextSimilarity;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Map;

public class StrUtil
extends CharSequenceUtil
implements StrPool {
    public static boolean isBlankIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str2 = strs[i];
            if (null == str2) continue;
            strs[i] = StrUtil.trim(str2);
        }
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    @Deprecated
    public static String str(Object obj, String charsetName) {
        return StrUtil.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes2, String charset) {
        return StrUtil.str(bytes2, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data2, Charset charset) {
        if (data2 == null) {
            return null;
        }
        if (null == charset) {
            return new String(data2);
        }
        return new String(data2, charset);
    }

    public static String str(Byte[] bytes2, String charset) {
        return StrUtil.str(bytes2, StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data2, Charset charset) {
        if (data2 == null) {
            return null;
        }
        byte[] bytes2 = new byte[data2.length];
        for (int i = 0; i < data2.length; ++i) {
            Byte dataByte = data2[i];
            bytes2[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtil.str(bytes2, charset);
    }

    public static String str(ByteBuffer data2, String charset) {
        if (data2 == null) {
            return null;
        }
        return StrUtil.str(data2, Charset.forName(charset));
    }

    public static String str(ByteBuffer data2, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data2).toString();
    }

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return StrBuilder.create();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StrBuilder strBuilder(int capacity) {
        return StrBuilder.create(capacity);
    }

    public static StringReader getReader(CharSequence str2) {
        if (null == str2) {
            return null;
        }
        return new StringReader(str2.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static String reverse(String str2) {
        return new String(ArrayUtil.reverse(str2.toCharArray()));
    }

    public static String fillBefore(String str2, char filledChar, int len) {
        return StrUtil.fill(str2, filledChar, len, true);
    }

    public static String fillAfter(String str2, char filledChar, int len) {
        return StrUtil.fill(str2, filledChar, len, false);
    }

    public static String fill(String str2, char filledChar, int len, boolean isPre) {
        int strLen = str2.length();
        if (strLen > len) {
            return str2;
        }
        String filledStr = StrUtil.repeat(filledChar, len - strLen);
        return isPre ? filledStr.concat(str2) : str2.concat(filledStr);
    }

    public static double similar(String str1, String str2) {
        return TextSimilarity.similar(str1, str2);
    }

    public static String similar(String str1, String str2, int scale) {
        return TextSimilarity.similar(str1, str2, scale);
    }

    public static String uuid() {
        return IdUtil.randomUUID();
    }

    public static String format(CharSequence template2, Map<?, ?> map2) {
        return StrUtil.format(template2, map2, true);
    }

    public static String format(CharSequence template2, Map<?, ?> map2, boolean ignoreNull) {
        return StrFormatter.format(template2, map2, ignoreNull);
    }
}

