/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

public class RadixUtil {
    public static final String RADIXS_34 = "0123456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String RADIXS_SHUFFLE_34 = "H3UM16TDFPSBZJ90CW28QYRE45AXKNGV7L";
    public static final String RADIXS_59 = "0123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final String RADIXS_SHUFFLE_59 = "vh9wGkfK8YmqbsoENP3764SeCX0dVzrgy1HRtpnTaLjJW2xQiZAcBMUFDu5";

    public static String encode(String radixs, int num2) {
        long tmpNum = num2 >= 0 ? (long)num2 : 0x100000000L - (long)(~num2 + 1);
        return RadixUtil.encode(radixs, tmpNum, 32);
    }

    public static String encode(String radixs, long num2) {
        if (num2 < 0L) {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u8d1f\u6570\uff01");
        }
        return RadixUtil.encode(radixs, num2, 64);
    }

    public static int decodeToInt(String radixs, String encodeStr) {
        return (int)RadixUtil.decode(radixs, encodeStr);
    }

    public static long decode(String radixs, String encodeStr) {
        int rl = radixs.length();
        long res = 0L;
        for (char c : encodeStr.toCharArray()) {
            res = res * (long)rl + (long)radixs.indexOf(c);
        }
        return res;
    }

    private static String encode(String radixs, long num2, int maxLength) {
        if (radixs.length() < 2) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u8fdb\u5236\u6700\u5c11\u4e24\u4e2a\u5b57\u7b26\u54e6\uff01");
        }
        int rl = radixs.length();
        long tmpNum = num2;
        char[] aa = new char[maxLength];
        int i = aa.length;
        do {
            aa[--i] = radixs.charAt((int)(tmpNum % (long)rl));
        } while ((tmpNum /= (long)rl) > 0L);
        return new String(aa, i, aa.length - i);
    }
}

