/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;

public class PrimitiveArrayUtil {
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(long[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(int[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(short[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(char[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(byte[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(double[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(float[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(boolean[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isNotEmpty(long[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(int[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(short[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(char[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(byte[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(double[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(float[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static boolean isNotEmpty(boolean[] array2) {
        return false == PrimitiveArrayUtil.isEmpty(array2);
    }

    public static byte[] resize(byte[] bytes2, int newSize) {
        if (newSize < 0) {
            return bytes2;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && PrimitiveArrayUtil.isNotEmpty(bytes2)) {
            System.arraycopy(bytes2, 0, newArray, 0, Math.min(bytes2.length, newSize));
        }
        return newArray;
    }

    public static byte[] addAll(byte[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (byte[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static int[] addAll(int[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (int[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        int[] result = new int[length];
        length = 0;
        for (int[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static long[] addAll(long[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (long[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        long[] result = new long[length];
        length = 0;
        for (long[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static double[] addAll(double[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (double[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        double[] result = new double[length];
        length = 0;
        for (double[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static float[] addAll(float[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (float[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        float[] result = new float[length];
        length = 0;
        for (float[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static char[] addAll(char[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (char[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        char[] result = new char[length];
        length = 0;
        for (char[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static boolean[] addAll(boolean[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (boolean[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        boolean[] result = new boolean[length];
        length = 0;
        for (boolean[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static short[] addAll(short[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (short[] array2 : arrays) {
            if (null == array2) continue;
            length += array2.length;
        }
        short[] result = new short[length];
        length = 0;
        for (short[] array3 : arrays) {
            if (null == array3) continue;
            System.arraycopy(array3, 0, result, length, array3.length);
            length += array3.length;
        }
        return result;
    }

    public static int[] range(int excludedEnd) {
        return PrimitiveArrayUtil.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return PrimitiveArrayUtil.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range2 = new int[length];
        for (int i = 0; i < length; ++i) {
            range2[i] = includedStart;
            includedStart += step;
        }
        return range2;
    }

    public static byte[][] split(byte[] array2, int len) {
        int amount = array2.length / len;
        int remainder = array2.length % len;
        if (remainder != 0) {
            ++amount;
        }
        byte[][] arrays = new byte[amount][];
        for (int i = 0; i < amount; ++i) {
            byte[] arr;
            if (i == amount - 1 && remainder != 0) {
                arr = new byte[remainder];
                System.arraycopy(array2, i * len, arr, 0, remainder);
            } else {
                arr = new byte[len];
                System.arraycopy(array2, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static int indexOf(long[] array2, long value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] array2, long value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(long[] array2, long value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(int[] array2, int value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] array2, int value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(int[] array2, int value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(short[] array2, short value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(short[] array2, short value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(short[] array2, short value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(char[] array2, char value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array2, char value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(char[] array2, char value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(byte[] array2, byte value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array2, byte value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(byte[] array2, byte value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(double[] array2, double value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (!NumberUtil.equals(value, array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(double[] array2, double value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (!NumberUtil.equals(value, array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(double[] array2, double value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(float[] array2, float value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (!NumberUtil.equals(value, array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(float[] array2, float value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (!NumberUtil.equals(value, array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(float[] array2, float value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static int indexOf(boolean[] array2, boolean value) {
        if (null != array2) {
            for (int i = 0; i < array2.length; ++i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array2, boolean value) {
        if (null != array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                if (value != array2[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(boolean[] array2, boolean value) {
        return PrimitiveArrayUtil.indexOf(array2, value) > -1;
    }

    public static Integer[] wrap(int ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Integer[0];
        }
        Integer[] array2 = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static int[] unWrap(Integer ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new int[0];
        }
        int[] array2 = new int[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], 0);
        }
        return array2;
    }

    public static Long[] wrap(long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Long[0];
        }
        Long[] array2 = new Long[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static long[] unWrap(Long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new long[0];
        }
        long[] array2 = new long[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], 0L);
        }
        return array2;
    }

    public static Character[] wrap(char ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Character[0];
        }
        Character[] array2 = new Character[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = Character.valueOf(values[i]);
        }
        return array2;
    }

    public static char[] unWrap(Character ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new char[0];
        }
        char[] array2 = new char[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], Character.valueOf('\u0000')).charValue();
        }
        return array2;
    }

    public static Byte[] wrap(byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Byte[0];
        }
        Byte[] array2 = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static byte[] unWrap(Byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new byte[0];
        }
        byte[] array2 = new byte[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], (byte)0);
        }
        return array2;
    }

    public static Short[] wrap(short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Short[0];
        }
        Short[] array2 = new Short[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static short[] unWrap(Short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new short[0];
        }
        short[] array2 = new short[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], (short)0);
        }
        return array2;
    }

    public static Float[] wrap(float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Float[0];
        }
        Float[] array2 = new Float[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = Float.valueOf(values[i]);
        }
        return array2;
    }

    public static float[] unWrap(Float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new float[0];
        }
        float[] array2 = new float[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], Float.valueOf(0.0f)).floatValue();
        }
        return array2;
    }

    public static Double[] wrap(double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Double[0];
        }
        Double[] array2 = new Double[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static double[] unWrap(Double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new double[0];
        }
        double[] array2 = new double[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], 0.0);
        }
        return array2;
    }

    public static Boolean[] wrap(boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new Boolean[0];
        }
        Boolean[] array2 = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = values[i];
        }
        return array2;
    }

    public static boolean[] unWrap(Boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return new boolean[0];
        }
        boolean[] array2 = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array2[i] = ObjectUtil.defaultIfNull(values[i], false);
        }
        return array2;
    }

    public static byte[] sub(byte[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new byte[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new byte[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static int[] sub(int[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new int[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new int[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static long[] sub(long[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new long[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new long[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static short[] sub(short[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new short[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new short[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static char[] sub(char[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new char[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new char[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static double[] sub(double[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new double[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new double[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static float[] sub(float[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new float[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new float[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    public static boolean[] sub(boolean[] array2, int start, int end) {
        int length = Array.getLength(array2);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new boolean[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new boolean[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array2, start, end);
    }

    @Deprecated
    public static String join(int[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(long[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(short[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (short item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(char[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (char item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(byte[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(boolean[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (boolean item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(float[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (float item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    @Deprecated
    public static String join(double[] array2, CharSequence conjunction) {
        if (null == array2) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (double item : array2) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static long[] remove(long[] array2, int index2) throws IllegalArgumentException {
        return (long[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static int[] remove(int[] array2, int index2) throws IllegalArgumentException {
        return (int[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static short[] remove(short[] array2, int index2) throws IllegalArgumentException {
        return (short[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static char[] remove(char[] array2, int index2) throws IllegalArgumentException {
        return (char[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static byte[] remove(byte[] array2, int index2) throws IllegalArgumentException {
        return (byte[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static double[] remove(double[] array2, int index2) throws IllegalArgumentException {
        return (double[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static float[] remove(float[] array2, int index2) throws IllegalArgumentException {
        return (float[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static boolean[] remove(boolean[] array2, int index2) throws IllegalArgumentException {
        return (boolean[])PrimitiveArrayUtil.remove((Object)array2, index2);
    }

    public static Object remove(Object array2, int index2) throws IllegalArgumentException {
        if (null == array2) {
            return null;
        }
        int length = Array.getLength(array2);
        if (index2 < 0 || index2 >= length) {
            return array2;
        }
        Object result = Array.newInstance(array2.getClass().getComponentType(), length - 1);
        System.arraycopy(array2, 0, result, 0, index2);
        if (index2 < length - 1) {
            System.arraycopy(array2, index2 + 1, result, index2, length - index2 - 1);
        }
        return result;
    }

    public static long[] removeEle(long[] array2, long element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static int[] removeEle(int[] array2, int element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static short[] removeEle(short[] array2, short element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static char[] removeEle(char[] array2, char element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static byte[] removeEle(byte[] array2, byte element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static double[] removeEle(double[] array2, double element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static float[] removeEle(float[] array2, float element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static boolean[] removeEle(boolean[] array2, boolean element) throws IllegalArgumentException {
        return PrimitiveArrayUtil.remove(array2, PrimitiveArrayUtil.indexOf(array2, element));
    }

    public static long[] reverse(long[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static long[] reverse(long[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static int[] reverse(int[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static int[] reverse(int[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static short[] reverse(short[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static short[] reverse(short[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static char[] reverse(char[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static char[] reverse(char[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static byte[] reverse(byte[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static byte[] reverse(byte[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static double[] reverse(double[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static double[] reverse(double[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static float[] reverse(float[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static float[] reverse(float[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static boolean[] reverse(boolean[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            return array2;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array2, i, j);
        }
        return array2;
    }

    public static boolean[] reverse(boolean[] array2) {
        return PrimitiveArrayUtil.reverse(array2, 0, array2.length);
    }

    public static long min(long ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min2 <= numberArray[i]) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static int min(int ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min2 <= numberArray[i]) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static short min(short ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min2 <= numberArray[i]) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static char min(char ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min2 <= numberArray[i]) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static byte min(byte ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min2 <= numberArray[i]) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static double min(double ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min2 > numberArray[i])) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static float min(float ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float min2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min2 > numberArray[i])) continue;
            min2 = numberArray[i];
        }
        return min2;
    }

    public static long max(long ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max2 >= numberArray[i]) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static int max(int ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max2 >= numberArray[i]) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static short max(short ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max2 >= numberArray[i]) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static char max(char ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max2 >= numberArray[i]) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static byte max(byte ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max2 >= numberArray[i]) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static double max(double ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max2 < numberArray[i])) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static float max(float ... numberArray) {
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float max2 = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max2 < numberArray[i])) continue;
            max2 = numberArray[i];
        }
        return max2;
    }

    public static int[] shuffle(int[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static int[] shuffle(int[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static long[] shuffle(long[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static long[] shuffle(long[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static double[] shuffle(double[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static double[] shuffle(double[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static float[] shuffle(float[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static float[] shuffle(float[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static boolean[] shuffle(boolean[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static boolean[] shuffle(boolean[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static byte[] shuffle(byte[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static byte[] shuffle(byte[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static char[] shuffle(char[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static char[] shuffle(char[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static short[] shuffle(short[] array2) {
        return PrimitiveArrayUtil.shuffle(array2, (Random)RandomUtil.getRandom());
    }

    public static short[] shuffle(short[] array2, Random random) {
        if (array2 == null || random == null || array2.length <= 1) {
            return array2;
        }
        for (int i = array2.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array2, i - 1, random.nextInt(i));
        }
        return array2;
    }

    public static int[] swap(int[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static long[] swap(long[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static double[] swap(double[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static float[] swap(float[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static boolean[] swap(boolean[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        boolean tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static byte[] swap(byte[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static char[] swap(char[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static short[] swap(short[] array2, int index1, int index2) {
        if (PrimitiveArrayUtil.isEmpty(array2)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short tmp = array2[index1];
        array2[index1] = array2[index2];
        array2[index2] = tmp;
        return array2;
    }

    public static boolean isSorted(byte[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(byte[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] <= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(byte[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] >= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(short[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(short[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] <= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(short[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] >= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(char[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(char[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] <= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(char[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] >= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(int[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] <= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(int[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] >= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(long[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(long[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] <= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(long[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (array2[i] >= array2[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(double[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(double[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (!(array2[i] > array2[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(double[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (!(array2[i] < array2[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(float[] array2) {
        return PrimitiveArrayUtil.isSortedASC(array2);
    }

    public static boolean isSortedASC(float[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (!(array2[i] > array2[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(float[] array2) {
        if (array2 == null) {
            return false;
        }
        for (int i = 0; i < array2.length - 1; ++i) {
            if (!(array2[i] < array2[i + 1])) continue;
            return false;
        }
        return true;
    }
}

