/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBUtil {
    public static String beanToXml(Object bean2) {
        return JAXBUtil.beanToXml(bean2, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String beanToXml(Object bean2, Charset charset, boolean format2) {
        StringWriter writer2;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean2.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format2);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            writer2 = new StringWriter();
            marshaller.marshal(bean2, (Writer)writer2);
        }
        catch (Exception e2) {
            throw new UtilException("convertToXml \u9519\u8bef\uff1a" + e2.getMessage(), e2);
        }
        return writer2.toString();
    }

    public static <T> T xmlToBean(String xml2, Class<T> c) {
        return JAXBUtil.xmlToBean(StrUtil.getReader(xml2), c);
    }

    public static <T> T xmlToBean(File file2, Charset charset, Class<T> c) {
        return JAXBUtil.xmlToBean(FileUtil.getReader(file2, charset), c);
    }

    public static <T> T xmlToBean(Reader reader2, Class<T> c) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(reader2);
            return (T)object;
        }
        catch (Exception e2) {
            throw new RuntimeException("convertToJava2 \u9519\u8bef\uff1a" + e2.getMessage(), e2);
        }
        finally {
            IoUtil.close(reader2);
        }
    }
}

