/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.hash.CityHash;
import cn.hutool.core.lang.hash.MurmurHash;
import cn.hutool.core.lang.hash.Number128;

public class HashUtil {
    public static int additiveHash(String key2, int prime) {
        int hash2 = key2.length();
        for (int i = 0; i < key2.length(); ++i) {
            hash2 += key2.charAt(i);
        }
        return hash2 % prime;
    }

    public static int rotatingHash(String key2, int prime) {
        int hash2 = key2.length();
        for (int i = 0; i < key2.length(); ++i) {
            hash2 = hash2 << 4 ^ hash2 >> 28 ^ key2.charAt(i);
        }
        return hash2 % prime;
    }

    public static int oneByOneHash(String key2) {
        int hash2 = 0;
        for (int i = 0; i < key2.length(); ++i) {
            hash2 += key2.charAt(i);
            hash2 += hash2 << 10;
            hash2 ^= hash2 >> 6;
        }
        hash2 += hash2 << 3;
        hash2 ^= hash2 >> 11;
        hash2 += hash2 << 15;
        return hash2;
    }

    public static int bernstein(String key2) {
        int hash2 = 0;
        for (int i = 0; i < key2.length(); ++i) {
            hash2 = 33 * hash2 + key2.charAt(i);
        }
        return hash2;
    }

    public static int universal(char[] key2, int mask, int[] tab) {
        int hash2 = key2.length;
        int len = key2.length;
        for (int i = 0; i < len << 3; i += 8) {
            char k = key2[i >> 3];
            if ((k & '\u0001') == 0) {
                hash2 ^= tab[i];
            }
            if ((k & 2) == 0) {
                hash2 ^= tab[i + 1];
            }
            if ((k & 4) == 0) {
                hash2 ^= tab[i + 2];
            }
            if ((k & 8) == 0) {
                hash2 ^= tab[i + 3];
            }
            if ((k & 0x10) == 0) {
                hash2 ^= tab[i + 4];
            }
            if ((k & 0x20) == 0) {
                hash2 ^= tab[i + 5];
            }
            if ((k & 0x40) == 0) {
                hash2 ^= tab[i + 6];
            }
            if ((k & 0x80) != 0) continue;
            hash2 ^= tab[i + 7];
        }
        return hash2 & mask;
    }

    public static int zobrist(char[] key2, int mask, int[][] tab) {
        int hash2 = key2.length;
        for (int i = 0; i < key2.length; ++i) {
            hash2 ^= tab[i][key2[i]];
        }
        return hash2 & mask;
    }

    public static int fnvHash(byte[] data2) {
        int p = 16777619;
        int hash2 = -2128831035;
        for (byte b : data2) {
            hash2 = (hash2 ^ b) * 16777619;
        }
        hash2 += hash2 << 13;
        hash2 ^= hash2 >> 7;
        hash2 += hash2 << 3;
        hash2 ^= hash2 >> 17;
        hash2 += hash2 << 5;
        return Math.abs(hash2);
    }

    public static int fnvHash(String data2) {
        int p = 16777619;
        int hash2 = -2128831035;
        for (int i = 0; i < data2.length(); ++i) {
            hash2 = (hash2 ^ data2.charAt(i)) * 16777619;
        }
        hash2 += hash2 << 13;
        hash2 ^= hash2 >> 7;
        hash2 += hash2 << 3;
        hash2 ^= hash2 >> 17;
        hash2 += hash2 << 5;
        return Math.abs(hash2);
    }

    public static int intHash(int key2) {
        key2 += ~(key2 << 15);
        key2 ^= key2 >>> 10;
        key2 += key2 << 3;
        key2 ^= key2 >>> 6;
        key2 += ~(key2 << 11);
        key2 ^= key2 >>> 16;
        return key2;
    }

    public static int rsHash(String str2) {
        int b = 378551;
        int a = 63689;
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 = hash2 * a + str2.charAt(i);
            a *= b;
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int jsHash(String str2) {
        int hash2 = 1315423911;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 ^= (hash2 << 5) + str2.charAt(i) + (hash2 >> 2);
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int pjwHash(String str2) {
        int bitsInUnsignedInt = 32;
        int threeQuarters = bitsInUnsignedInt * 3 / 4;
        int oneEighth = bitsInUnsignedInt / 8;
        int highBits = -1 << bitsInUnsignedInt - oneEighth;
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            int test2 = (hash2 = (hash2 << oneEighth) + str2.charAt(i)) & highBits;
            if (test2 == 0) continue;
            hash2 = (hash2 ^ test2 >> threeQuarters) & ~highBits;
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int elfHash(String str2) {
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            int x = (int)((long)(hash2 = (hash2 << 4) + str2.charAt(i)) & 0xF0000000L);
            if (x == 0) continue;
            hash2 ^= x >> 24;
            hash2 &= ~x;
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int bkdrHash(String str2) {
        int seed = 131;
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 = hash2 * seed + str2.charAt(i);
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int sdbmHash(String str2) {
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 = str2.charAt(i) + (hash2 << 6) + (hash2 << 16) - hash2;
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int djbHash(String str2) {
        int hash2 = 5381;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 = (hash2 << 5) + hash2 + str2.charAt(i);
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int dekHash(String str2) {
        int hash2 = str2.length();
        for (int i = 0; i < str2.length(); ++i) {
            hash2 = hash2 << 5 ^ hash2 >> 27 ^ str2.charAt(i);
        }
        return hash2 & Integer.MAX_VALUE;
    }

    public static int apHash(String str2) {
        int hash2 = 0;
        for (int i = 0; i < str2.length(); ++i) {
            hash2 ^= (i & 1) == 0 ? hash2 << 7 ^ str2.charAt(i) ^ hash2 >> 3 : ~(hash2 << 11 ^ str2.charAt(i) ^ hash2 >> 5);
        }
        return hash2;
    }

    public static long tianlHash(String str2) {
        int iLength = str2.length();
        if (iLength == 0) {
            return 0L;
        }
        long hash2 = iLength <= 256 ? 0x1000000L * (long)(iLength - 1) : 0xFF000000L;
        if (iLength <= 96) {
            for (int i = 1; i <= iLength; ++i) {
                char ucChar = str2.charAt(i - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash2 += (long)((3 * i * ucChar * ucChar + 5 * i * ucChar + 7 * i + 11 * ucChar) % 0x1000000);
            }
        } else {
            for (int i = 1; i <= 96; ++i) {
                char ucChar = str2.charAt(i + iLength - 96 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash2 += (long)((3 * i * ucChar * ucChar + 5 * i * ucChar + 7 * i + 11 * ucChar) % 0x1000000);
            }
        }
        if (hash2 < 0L) {
            hash2 *= -1L;
        }
        return hash2;
    }

    public static int javaDefaultHash(String str2) {
        int h = 0;
        int off = 0;
        int len = str2.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + str2.charAt(off++);
        }
        return h;
    }

    public static long mixHash(String str2) {
        long hash2 = str2.hashCode();
        hash2 <<= 32;
        return hash2 |= (long)HashUtil.fnvHash(str2);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static int murmur32(byte[] data2) {
        return MurmurHash.hash32(data2);
    }

    public static long murmur64(byte[] data2) {
        return MurmurHash.hash64(data2);
    }

    public static long[] murmur128(byte[] data2) {
        return MurmurHash.hash128(data2);
    }

    public static int cityHash32(byte[] data2) {
        return CityHash.hash32(data2);
    }

    public static long cityHash64(byte[] data2, long seed) {
        return CityHash.hash64(data2, seed);
    }

    public static long cityHash64(byte[] data2, long seed0, long seed1) {
        return CityHash.hash64(data2, seed0, seed1);
    }

    public static long cityHash64(byte[] data2) {
        return CityHash.hash64(data2);
    }

    public static long[] cityHash128(byte[] data2) {
        return CityHash.hash128(data2).getLongArray();
    }

    public static long[] cityHash128(byte[] data2, Number128 seed) {
        return CityHash.hash128(data2).getLongArray();
    }
}

