/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnumUtil {
    public static boolean isEnum(Class<?> clazz) {
        Assert.notNull(clazz);
        return clazz.isEnum();
    }

    public static boolean isEnum(Object obj) {
        Assert.notNull(obj);
        return obj.getClass().isEnum();
    }

    public static String toString(Enum<?> e2) {
        return null != e2 ? e2.name() : null;
    }

    public static <E extends Enum<E>> E getEnumAt(Class<E> enumClass, int index2) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return (E)(index2 >= 0 && index2 < enumConstants.length ? enumConstants[index2] : null);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        return (E)((Enum)ObjectUtil.defaultIfNull(EnumUtil.fromStringQuietly(enumClass, value), defaultValue));
    }

    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        if (null == enumClass || StrUtil.isBlank(value)) {
            return null;
        }
        try {
            return EnumUtil.fromString(enumClass, value);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = ReflectUtil.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(fieldName)) continue;
            for (Enum enumObj : enums) {
                if (!ObjectUtil.equal(value, ReflectUtil.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e2 : enums) {
            list.add(e2.name());
        }
        return list;
    }

    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e2 : enums) {
            list.add(ReflectUtil.getFieldValue(e2, fieldName));
        }
        return list;
    }

    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        Field[] fields;
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields = ReflectUtil.getFields(clazz)) {
            String name2 = field.getName();
            if (field.getType().isEnum() || name2.contains("$VALUES") || "ordinal".equals(name2) || names.contains(name2)) continue;
            names.add(name2);
        }
        return names;
    }

    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        LinkedHashMap<String, Enum> map2 = new LinkedHashMap<String, Enum>();
        for (Enum e2 : (Enum[])enumClass.getEnumConstants()) {
            map2.put(e2.name(), e2);
        }
        return map2;
    }

    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        HashMap<String, Object> map2 = MapUtil.newHashMap(enums.length, true);
        for (Enum<?> e2 : enums) {
            map2.put(e2.name(), ReflectUtil.getFieldValue(e2, fieldName));
        }
        return map2;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val2) {
        return EnumUtil.getEnumMap(enumClass).containsKey(val2);
    }

    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val2) {
        return false == EnumUtil.contains(enumClass, val2);
    }

    public static boolean equalsIgnoreCase(Enum<?> e2, String val2) {
        return StrUtil.equalsIgnoreCase(EnumUtil.toString(e2), val2);
    }

    public static boolean equals(Enum<?> e2, String val2) {
        return StrUtil.equals(EnumUtil.toString(e2), val2);
    }
}

