/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.StrUtil;

public class DesensitizedUtil {
    public static String desensitized(CharSequence str2, DesensitizedType desensitizedType) {
        if (StrUtil.isBlank(str2)) {
            return "";
        }
        String newStr = String.valueOf(str2);
        switch (desensitizedType) {
            case USER_ID: {
                newStr = String.valueOf(DesensitizedUtil.userId());
                break;
            }
            case CHINESE_NAME: {
                newStr = DesensitizedUtil.chineseName(String.valueOf(str2));
                break;
            }
            case ID_CARD: {
                newStr = DesensitizedUtil.idCardNum(String.valueOf(str2), 1, 2);
                break;
            }
            case FIXED_PHONE: {
                newStr = DesensitizedUtil.fixedPhone(String.valueOf(str2));
                break;
            }
            case MOBILE_PHONE: {
                newStr = DesensitizedUtil.mobilePhone(String.valueOf(str2));
                break;
            }
            case ADDRESS: {
                newStr = DesensitizedUtil.address(String.valueOf(str2), 8);
                break;
            }
            case EMAIL: {
                newStr = DesensitizedUtil.email(String.valueOf(str2));
                break;
            }
            case PASSWORD: {
                newStr = DesensitizedUtil.password(String.valueOf(str2));
                break;
            }
            case CAR_LICENSE: {
                newStr = DesensitizedUtil.carLicense(String.valueOf(str2));
                break;
            }
            case BANK_CARD: {
                newStr = DesensitizedUtil.bankCard(String.valueOf(str2));
                break;
            }
        }
        return newStr;
    }

    public static Long userId() {
        return 0L;
    }

    public static String chineseName(String fullName) {
        if (StrUtil.isBlank(fullName)) {
            return "";
        }
        return StrUtil.hide(fullName, 1, fullName.length());
    }

    public static String idCardNum(String idCardNum, int front, int end) {
        if (StrUtil.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StrUtil.hide(idCardNum, front, idCardNum.length() - end);
    }

    public static String fixedPhone(String num2) {
        if (StrUtil.isBlank(num2)) {
            return "";
        }
        return StrUtil.hide(num2, 4, num2.length() - 2);
    }

    public static String mobilePhone(String num2) {
        if (StrUtil.isBlank(num2)) {
            return "";
        }
        return StrUtil.hide(num2, 3, num2.length() - 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StrUtil.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StrUtil.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (StrUtil.isBlank(email)) {
            return "";
        }
        int index2 = StrUtil.indexOf(email, '@');
        if (index2 <= 1) {
            return email;
        }
        return StrUtil.hide(email, 1, index2);
    }

    public static String password(String password) {
        if (StrUtil.isBlank(password)) {
            return "";
        }
        return StrUtil.repeat('*', password.length());
    }

    public static String carLicense(String carLicense) {
        if (StrUtil.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StrUtil.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            carLicense = StrUtil.hide(carLicense, 3, 7);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo) {
        if (StrUtil.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = StrUtil.trim(bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int midLength = length - 8;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - 4, length);
        return buf.toString();
    }

    public static enum DesensitizedType {
        USER_ID,
        CHINESE_NAME,
        ID_CARD,
        FIXED_PHONE,
        MOBILE_PHONE,
        ADDRESS,
        EMAIL,
        PASSWORD,
        CAR_LICENSE,
        BANK_CARD;

    }
}

