/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.convert.BasicType;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new ConcurrentHashMap(32);
    private static final SimpleCache<String, Class<?>> CLASS_CACHE = new SimpleCache();

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassLoaderUtil.class.getClassLoader())) {
            classLoader = ClassLoaderUtil.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String name2) throws UtilException {
        return ClassLoaderUtil.loadClass(name2, true);
    }

    public static Class<?> loadClass(String name2, boolean isInitialized) throws UtilException {
        return ClassLoaderUtil.loadClass(name2, null, isInitialized);
    }

    public static Class<?> loadClass(String name2, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        Class<?> clazz;
        block11: {
            Assert.notNull(name2, "Name must not be null", new Object[0]);
            clazz = ClassLoaderUtil.loadPrimitiveClass(name2);
            if (clazz == null) {
                clazz = CLASS_CACHE.get(name2);
            }
            if (clazz != null) {
                return clazz;
            }
            if (name2.endsWith(ARRAY_SUFFIX)) {
                String elementClassName = name2.substring(0, name2.length() - ARRAY_SUFFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementClassName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name2.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name2.endsWith(";")) {
                String elementName = name2.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name2.length() - 1);
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name2.startsWith(INTERNAL_ARRAY_PREFIX)) {
                String elementName = name2.substring(INTERNAL_ARRAY_PREFIX.length());
                Class<?> elementClass = ClassLoaderUtil.loadClass(elementName, classLoader, isInitialized);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                if (null == classLoader) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName(name2, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassLoaderUtil.tryLoadInnerClass(name2, classLoader, isInitialized);
                    if (null != clazz) break block11;
                    throw new UtilException(ex);
                }
            }
        }
        return CLASS_CACHE.put(name2, clazz);
    }

    public static Class<?> loadPrimitiveClass(String name2) {
        Class<?> result = null;
        if (StrUtil.isNotBlank(name2) && (name2 = name2.trim()).length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name2);
        }
        return result;
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name2) {
        try {
            return ClassLoaderUtil.getJarClassLoader(jarOrDir).loadClass(name2);
        }
        catch (ClassNotFoundException e2) {
            throw new UtilException(e2);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtil.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.loadClass(className, classLoader, false);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static Class<?> tryLoadInnerClass(String name2, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name2.lastIndexOf(46);
        if (lastDotIndex > 0) {
            String innerClassName = name2.substring(0, lastDotIndex) + '$' + name2.substring(lastDotIndex + 1);
            try {
                return Class.forName(innerClassName, isInitialized, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

