/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.replacer;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.replacer.StrReplacer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LookupReplacer
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> lookupMap = new HashMap<String, String>();
    private final Set<Character> prefixSet = new HashSet<Character>();
    private final int minLength;
    private final int maxLength;

    public LookupReplacer(String[] ... lookup) {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (String[] pair : lookup) {
            String key2 = pair[0];
            this.lookupMap.put(key2, pair[1]);
            this.prefixSet.add(Character.valueOf(key2.charAt(0)));
            int keySize = key2.length();
            if (keySize > maxLength) {
                maxLength = keySize;
            }
            if (keySize >= minLength) continue;
            minLength = keySize;
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    @Override
    protected int replace(CharSequence str2, int pos, StrBuilder out) {
        if (this.prefixSet.contains(Character.valueOf(str2.charAt(pos)))) {
            int max2 = this.maxLength;
            if (pos + this.maxLength > str2.length()) {
                max2 = str2.length() - pos;
            }
            for (int i = max2; i >= this.minLength; --i) {
                CharSequence subSeq = str2.subSequence(pos, pos + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (null == result) continue;
                out.append(result);
                return i;
            }
        }
        return 0;
    }
}

