/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.csv;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class CsvRow
implements List<String> {
    private final long originalLineNumber;
    final Map<String, Integer> headerMap;
    final List<String> fields;

    public CsvRow(long originalLineNumber, Map<String, Integer> headerMap, List<String> fields) {
        Assert.notNull(fields, "fields must be not null!", new Object[0]);
        this.originalLineNumber = originalLineNumber;
        this.headerMap = headerMap;
        this.fields = fields;
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getByName(String name2) {
        Assert.notNull(this.headerMap, "No header available!", new Object[0]);
        Integer col = this.headerMap.get(name2);
        if (col != null) {
            return this.get(col);
        }
        return null;
    }

    public List<String> getRawList() {
        return this.fields;
    }

    public Map<String, String> getFieldMap() {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>(this.headerMap.size(), 1.0f);
        for (Map.Entry<String, Integer> header : this.headerMap.entrySet()) {
            String key2 = header.getKey();
            Integer col = this.headerMap.get(key2);
            String val2 = null == col ? null : this.get(col);
            fieldMap.put(key2, val2);
        }
        return fieldMap;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.toBeanIgnoreError(this.getFieldMap(), clazz);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.fields.contains(o);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.fields.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.fields.toArray(a);
    }

    @Override
    public boolean add(String e2) {
        return this.fields.add(e2);
    }

    @Override
    public boolean remove(Object o) {
        return this.fields.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.fields.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        return this.fields.addAll(c);
    }

    @Override
    public boolean addAll(int index2, Collection<? extends String> c) {
        return this.fields.addAll(index2, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.fields.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.fields.retainAll(c);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    @Override
    public String get(int index2) {
        return index2 >= this.fields.size() ? null : this.fields.get(index2);
    }

    @Override
    public String set(int index2, String element) {
        return this.fields.set(index2, element);
    }

    @Override
    public void add(int index2, String element) {
        this.fields.add(index2, element);
    }

    @Override
    public String remove(int index2) {
        return this.fields.remove(index2);
    }

    @Override
    public int indexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.fields.lastIndexOf(o);
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.fields.listIterator();
    }

    @Override
    public ListIterator<String> listIterator(int index2) {
        return this.fields.listIterator(index2);
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return this.fields.subList(fromIndex, toIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CsvRow{");
        sb.append("originalLineNumber=");
        sb.append(this.originalLineNumber);
        sb.append(", ");
        sb.append("fields=");
        if (this.headerMap != null) {
            sb.append('{');
            Iterator<Map.Entry<String, String>> it = this.getFieldMap().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                sb.append(entry.getKey());
                sb.append('=');
                if (entry.getValue() != null) {
                    sb.append(entry.getValue());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        } else {
            sb.append(this.fields.toString());
        }
        sb.append('}');
        return sb.toString();
    }
}

