/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrSplitter {
    public static List<String> splitPath(String str2) {
        return StrSplitter.splitPath(str2, 0);
    }

    public static String[] splitPathToArray(String str2) {
        return StrSplitter.toArray(StrSplitter.splitPath(str2));
    }

    public static List<String> splitPath(String str2, int limit) {
        return StrSplitter.split(str2, '/', limit, true, true);
    }

    public static String[] splitPathToArray(String str2, int limit) {
        return StrSplitter.toArray(StrSplitter.splitPath(str2, limit));
    }

    public static List<String> splitTrim(String str2, char separator, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, 0, true, ignoreEmpty);
    }

    public static List<String> split(String str2, char separator, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, 0, isTrim, ignoreEmpty);
    }

    public static List<String> splitTrim(String str2, char separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, true, ignoreEmpty, false);
    }

    public static List<String> split(String str2, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitIgnoreCase(String str2, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> split(String str2, char separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StrUtil.isEmpty(str2)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str2, isTrim, ignoreEmpty);
        }
        ArrayList<String> list = new ArrayList<String>(limit > 0 ? limit : 16);
        int len = str2.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!NumberUtil.equals(separator, str2.charAt(i), ignoreCase)) continue;
            StrSplitter.addToList(list, str2.substring(start, i), isTrim, ignoreEmpty);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StrSplitter.addToList(list, str2.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str2, char separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str2, String separator, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, -1, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str2, String separator, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, true, ignoreEmpty);
    }

    public static List<String> split(String str2, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty, false);
    }

    public static List<String> splitTrim(String str2, String separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, true, ignoreEmpty);
    }

    public static List<String> splitIgnoreCase(String str2, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty, true);
    }

    public static List<String> splitTrimIgnoreCase(String str2, String separator, int limit, boolean ignoreEmpty) {
        return StrSplitter.split(str2, separator, limit, true, ignoreEmpty, true);
    }

    public static List<String> split(String str2, String separator, int limit, boolean isTrim, boolean ignoreEmpty, boolean ignoreCase) {
        if (StrUtil.isEmpty(str2)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str2, isTrim, ignoreEmpty);
        }
        if (StrUtil.isEmpty(separator)) {
            return StrSplitter.split(str2, limit);
        }
        if (separator.length() == 1) {
            return StrSplitter.split(str2, separator.charAt(0), limit, isTrim, ignoreEmpty, ignoreCase);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str2.length();
        int separatorLen = separator.length();
        int start = 0;
        int i = 0;
        while (i < len && (i = StrUtil.indexOf((CharSequence)str2, separator, start, ignoreCase)) > -1) {
            StrSplitter.addToList(list, str2.substring(start, i), isTrim, ignoreEmpty);
            start = i + separatorLen;
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StrSplitter.addToList(list, str2.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str2, String separator, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str2, separator, limit, isTrim, ignoreEmpty));
    }

    public static List<String> split(String str2, int limit) {
        if (StrUtil.isEmpty(str2)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str2, true, true);
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = str2.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (!CharUtil.isBlankChar(str2.charAt(i))) continue;
            StrSplitter.addToList(list, str2.substring(start, i), true, true);
            start = i + 1;
            if (limit > 0 && list.size() > limit - 2) break;
        }
        return StrSplitter.addToList(list, str2.substring(start, len), true, true);
    }

    public static String[] splitToArray(String str2, int limit) {
        return StrSplitter.toArray(StrSplitter.split(str2, limit));
    }

    public static List<String> splitByRegex(String str2, String separatorRegex, int limit, boolean isTrim, boolean ignoreEmpty) {
        Pattern pattern = PatternPool.get(separatorRegex);
        return StrSplitter.split(str2, pattern, limit, isTrim, ignoreEmpty);
    }

    public static List<String> split(String str2, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        if (StrUtil.isEmpty(str2)) {
            return new ArrayList<String>(0);
        }
        if (limit == 1) {
            return StrSplitter.addToList(new ArrayList<String>(1), str2, isTrim, ignoreEmpty);
        }
        if (null == separatorPattern) {
            return StrSplitter.split(str2, limit);
        }
        Matcher matcher = separatorPattern.matcher(str2);
        ArrayList<String> list = new ArrayList<String>();
        int len = str2.length();
        int start = 0;
        while (matcher.find()) {
            StrSplitter.addToList(list, str2.substring(start, matcher.start()), isTrim, ignoreEmpty);
            start = matcher.end();
            if (limit <= 0 || list.size() <= limit - 2) continue;
            break;
        }
        return StrSplitter.addToList(list, str2.substring(start, len), isTrim, ignoreEmpty);
    }

    public static String[] splitToArray(String str2, Pattern separatorPattern, int limit, boolean isTrim, boolean ignoreEmpty) {
        return StrSplitter.toArray(StrSplitter.split(str2, separatorPattern, limit, isTrim, ignoreEmpty));
    }

    public static String[] splitByLength(String str2, int len) {
        int partCount = str2.length() / len;
        int lastPartCount = str2.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str2.substring(i * len, i * len + lastPartCount) : str2.substring(i * len, i * len + len);
        }
        return strs;
    }

    private static List<String> addToList(List<String> list, String part, boolean isTrim, boolean ignoreEmpty) {
        if (isTrim) {
            part = StrUtil.trim(part);
        }
        if (!ignoreEmpty || !part.isEmpty()) {
            list.add(part);
        }
        return list;
    }

    private static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }
}

