/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrMatcher {
    List<String> patterns;

    public StrMatcher(String pattern) {
        this.patterns = StrMatcher.parse(pattern);
    }

    public Map<String, String> match(String text) {
        HashMap<String, String> result = MapUtil.newHashMap(true);
        int from = 0;
        String key2 = null;
        for (String part : this.patterns) {
            if (StrUtil.isWrap((CharSequence)part, "${", "}")) {
                key2 = StrUtil.sub(part, 2, part.length() - 1);
                continue;
            }
            int to = text.indexOf(part, from);
            if (to < 0) {
                return MapUtil.empty();
            }
            if (null != key2 && to > from) {
                result.put(key2, text.substring(from, to));
            }
            from = to + part.length();
            key2 = null;
        }
        if (null != key2 && from < text.length()) {
            result.put(key2, text.substring(from));
        }
        return result;
    }

    private static List<String> parse(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        int length = pattern.length();
        char c = '\u0000';
        boolean inVar = false;
        StrBuilder part = StrUtil.strBuilder();
        for (int i = 0; i < length; ++i) {
            char pre = c;
            c = pattern.charAt(i);
            if (inVar) {
                part.append(c);
                if ('}' != c) continue;
                inVar = false;
                patterns.add(part.toString());
                part.clear();
                continue;
            }
            if ('{' == c && '$' == pre) {
                inVar = true;
                String preText = part.subString(0, part.length() - 1);
                if (StrUtil.isNotEmpty(preText)) {
                    patterns.add(preText);
                }
                part.reset().append(pre).append(c);
                continue;
            }
            part.append(c);
        }
        if (part.length() > 0) {
            patterns.add(part.toString());
        }
        return patterns;
    }
}

