/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.stream;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.stream.CollectorUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array2) {
        Assert.notNull(array2, "Array must be not null!", new Object[0]);
        return Stream.of(array2);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        Assert.notNull(iterable, "Iterable must be not null!", new Object[0]);
        return StreamSupport.stream(Spliterators.spliterator(CollUtil.toCollection(iterable), 0), parallel);
    }

    public static Stream<String> of(File file2) {
        return StreamUtil.of(file2, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(Path path2) {
        return StreamUtil.of(path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(File file2, Charset charset) {
        Assert.notNull(file2, "File must be not null!", new Object[0]);
        return StreamUtil.of(file2.toPath(), charset);
    }

    public static Stream<String> of(Path path2, Charset charset) {
        try {
            return Files.lines(path2, charset);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        return stream.collect(CollectorUtil.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return stream.collect(CollectorUtil.joining(delimiter, toStringFunc));
    }
}

