/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net;

import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class URLDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte ESCAPE_CHAR = 37;

    public static String decodeForPath(String str2, Charset charset) {
        return URLDecoder.decode(str2, charset, false);
    }

    public static String decode(String str2, Charset charset) {
        return URLDecoder.decode(str2, charset, true);
    }

    public static String decode(String str2, Charset charset, boolean isPlusToSpace) {
        return StrUtil.str(URLDecoder.decode(StrUtil.bytes((CharSequence)str2, charset), isPlusToSpace), charset);
    }

    public static byte[] decode(byte[] bytes2) {
        return URLDecoder.decode(bytes2, true);
    }

    public static byte[] decode(byte[] bytes2, boolean isPlusToSpace) {
        if (bytes2 == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bytes2.length);
        for (int i = 0; i < bytes2.length; ++i) {
            int b = bytes2[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes2.length && (u = CharUtil.digit16(bytes2[i + 1])) >= 0 && i + 2 < bytes2.length && (l = CharUtil.digit16(bytes2[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }
}

