/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.reflect;

import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeMapperPool {
    private static final SimpleCache<Type, Map<Type, Type>> CACHE = new SimpleCache();

    public static Map<Type, Type> get(Type type2) {
        return CACHE.get(type2, () -> ActualTypeMapperPool.createTypeMap(type2));
    }

    public static Type getActualType(Type type2, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapperPool.get(type2);
        Type result = typeTypeMap.get(typeVariable);
        while (result instanceof TypeVariable) {
            result = typeTypeMap.get(result);
        }
        return result;
    }

    public static Type[] getActualTypes(Type type2, Type ... typeVariables) {
        Type[] result = new Type[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? ActualTypeMapperPool.getActualType(type2, (TypeVariable)typeVariables[i]) : typeVariables[i];
        }
        return result;
    }

    private static Map<Type, Type> createTypeMap(Type type2) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type2 && null != (parameterizedType = TypeUtil.toParameterizedType(type2))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                typeMap.put(typeParameters[i], typeArguments[i]);
            }
            type2 = rawType;
        }
        return typeMap;
    }
}

