/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.func.Func0;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

public class SimpleCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Map<K, Lock> keyLockMap = new ConcurrentHashMap<K, Lock>();

    public SimpleCache() {
        this(new WeakHashMap());
    }

    public SimpleCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    public V get(K key2) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key2);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public V get(K key2, Func0<V> supplier) {
        return this.get(key2, null, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key2, Predicate<V> validPredicate, Func0<V> supplier) {
        V v;
        block6: {
            v = this.get(key2);
            if (null == v && null != supplier) {
                Lock keyLock = this.keyLockMap.computeIfAbsent(key2, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    v = this.cache.get(key2);
                    if (null != v && (null == validPredicate || validPredicate.test(v))) break block6;
                    try {
                        v = supplier.call();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    this.put(key2, v);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key2);
                }
            }
        }
        return v;
    }

    public V put(K key2, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key2, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key2) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key2);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.cache.entrySet().iterator();
    }
}

