/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ObjectUtil;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;

public class ResourceClassLoader<T extends Resource>
extends SecureClassLoader {
    private final Map<String, T> resourceMap;

    public ResourceClassLoader(ClassLoader parentClassLoader, Map<String, T> resourceMap) {
        super(ObjectUtil.defaultIfNull(parentClassLoader, ClassLoaderUtil.getClassLoader()));
        this.resourceMap = ObjectUtil.defaultIfNull(resourceMap, new HashMap());
    }

    public ResourceClassLoader<T> addResource(T resource2) {
        this.resourceMap.put(resource2.getName(), resource2);
        return this;
    }

    @Override
    protected Class<?> findClass(String name2) throws ClassNotFoundException {
        Resource resource2 = (Resource)this.resourceMap.get(name2);
        if (null != resource2) {
            byte[] bytes2 = resource2.readBytes();
            return this.defineClass(name2, bytes2, 0, bytes2.length);
        }
        return super.findClass(name2);
    }
}

