/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.ConsoleTable;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Scanner;

public class Console {
    private static final String TEMPLATE_VAR = "{}";

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e2 = (Throwable)obj;
            Console.log(e2, e2.getMessage(), new Object[0]);
        } else {
            Console.log(TEMPLATE_VAR, obj);
        }
    }

    public static void log(Object obj1, Object ... otherObjs) {
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.log(obj1);
        } else {
            Console.log(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(otherObjs, 0, obj1));
        }
    }

    public static void log(String template2, Object ... values) {
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template2, TEMPLATE_VAR)) {
            Console.logInternal(template2, values);
        } else {
            Console.logInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(values, 0, new Object[]{template2}));
        }
    }

    public static void log(Throwable t, String template2, Object ... values) {
        System.out.println(StrUtil.format(template2, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    private static void logInternal(String template2, Object ... values) {
        Console.log(null, template2, values);
    }

    public static void table(ConsoleTable consoleTable) {
        Console.print(consoleTable.toString());
    }

    public static void print(Object obj) {
        Console.print(TEMPLATE_VAR, obj);
    }

    public static void print(Object obj1, Object ... otherObjs) {
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.print(obj1);
        } else {
            Console.print(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(otherObjs, 0, obj1));
        }
    }

    public static void print(String template2, Object ... values) {
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template2, TEMPLATE_VAR)) {
            Console.printInternal(template2, values);
        } else {
            Console.printInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(values, 0, new Object[]{template2}));
        }
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", Character.valueOf('\r'), StrUtil.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    private static void printInternal(String template2, Object ... values) {
        System.out.print(StrUtil.format(template2, values));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e2 = (Throwable)obj;
            Console.error(e2, e2.getMessage(), new Object[0]);
        } else {
            Console.error(TEMPLATE_VAR, obj);
        }
    }

    public static void error(Object obj1, Object ... otherObjs) {
        if (ArrayUtil.isEmpty(otherObjs)) {
            Console.error(obj1);
        } else {
            Console.error(Console.buildTemplateSplitBySpace(otherObjs.length + 1), ArrayUtil.insert(otherObjs, 0, obj1));
        }
    }

    public static void error(String template2, Object ... values) {
        if (ArrayUtil.isEmpty(values) || StrUtil.contains((CharSequence)template2, TEMPLATE_VAR)) {
            Console.errorInternal(template2, values);
        } else {
            Console.errorInternal(Console.buildTemplateSplitBySpace(values.length + 1), ArrayUtil.insert(values, 0, new Object[]{template2}));
        }
    }

    public static void error(Throwable t, String template2, Object ... values) {
        System.err.println(StrUtil.format(template2, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String template2, Object ... values) {
        Console.error(null, template2, values);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().nextLine();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int count2) {
        return StrUtil.repeatAndJoin(TEMPLATE_VAR, count2, " ");
    }
}

