/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.watch;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.watch.WatchMonitor;
import cn.hutool.core.io.watch.Watcher;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;

public class WatchUtil {
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(URLUtil.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file2, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file2, 0, events);
    }

    public static WatchMonitor create(File file2, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(file2.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path2, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path2, 0, events);
    }

    public static WatchMonitor create(String path2, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(Paths.get(path2, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path2, WatchEvent.Kind<?> ... events) {
        return WatchUtil.create(path2, 0, events);
    }

    public static WatchMonitor create(Path path2, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path2, maxDepth, events);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        return WatchUtil.createAll(url, 0, watcher);
    }

    public static WatchMonitor createAll(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchUtil.createAll(uri, 0, watcher);
    }

    public static WatchMonitor createAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createAll(File file2, Watcher watcher) {
        return WatchUtil.createAll(file2, 0, watcher);
    }

    public static WatchMonitor createAll(File file2, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(file2.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String path2, Watcher watcher) {
        return WatchUtil.createAll(path2, 0, watcher);
    }

    public static WatchMonitor createAll(String path2, int maxDepth, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(path2, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createAll(Path path2, Watcher watcher) {
        return WatchUtil.createAll(path2, 0, watcher);
    }

    public static WatchMonitor createAll(Path path2, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path2, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL url, Watcher watcher) {
        return WatchUtil.createModify(url, 0, watcher);
    }

    public static WatchMonitor createModify(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createModify(URI uri, Watcher watcher) {
        return WatchUtil.createModify(uri, 0, watcher);
    }

    public static WatchMonitor createModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createModify(File file2, Watcher watcher) {
        return WatchUtil.createModify(file2, 0, watcher);
    }

    public static WatchMonitor createModify(File file2, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(file2.toPath(), 0, watcher);
    }

    public static WatchMonitor createModify(String path2, Watcher watcher) {
        return WatchUtil.createModify(path2, 0, watcher);
    }

    public static WatchMonitor createModify(String path2, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(path2, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createModify(Path path2, Watcher watcher) {
        return WatchUtil.createModify(path2, 0, watcher);
    }

    public static WatchMonitor createModify(Path path2, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path2, maxDepth, WatchMonitor.ENTRY_MODIFY);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watcher, WatchEvent.Kind<?> ... events) {
        try {
            return watchable.register(watcher, events);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }
}

