/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.resource;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.URLUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;

    public FileResource(Path path2) {
        this(path2.toFile());
    }

    public FileResource(File file2) {
        this(file2, file2.getName());
    }

    public FileResource(File file2, String fileName) {
        this.file = file2;
    }

    public FileResource(String path2) {
        this(FileUtil.file(path2));
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public URL getUrl() {
        return URLUtil.getURL(this.file);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        return FileUtil.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return null == this.file ? "null" : this.file.toString();
    }
}

