/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.visitor.CopyVisitor;
import cn.hutool.core.io.file.visitor.DelVisitor;
import cn.hutool.core.io.file.visitor.MoveVisitor;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class PathUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirEmpty(Path dirPath) {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dirPath);){
            boolean bl = false == dirStream.iterator().hasNext();
            return bl;
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static List<File> loopFiles(Path path2, int maxDepth, final FileFilter fileFilter) {
        final ArrayList<File> fileList = new ArrayList<File>();
        if (null == path2 || !Files.exists(path2, new LinkOption[0])) {
            return fileList;
        }
        if (!PathUtil.isDirectory(path2)) {
            File file2 = path2.toFile();
            if (null == fileFilter || fileFilter.accept(file2)) {
                fileList.add(file2);
            }
            return fileList;
        }
        PathUtil.walkFiles(path2, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path2, BasicFileAttributes attrs) {
                File file2 = path2.toFile();
                if (null == fileFilter || fileFilter.accept(file2)) {
                    fileList.add(file2);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    public static void walkFiles(Path start, FileVisitor<? super Path> visitor) {
        PathUtil.walkFiles(start, -1, visitor);
    }

    public static void walkFiles(Path start, int maxDepth, FileVisitor<? super Path> visitor) {
        if (maxDepth < 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        try {
            Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static boolean del(Path path2) throws IORuntimeException {
        if (Files.notExists(path2, new LinkOption[0])) {
            return true;
        }
        try {
            if (PathUtil.isDirectory(path2)) {
                Files.walkFileTree(path2, DelVisitor.INSTANCE);
            } else {
                PathUtil.delFile(path2);
            }
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return true;
    }

    public static Path copyFile(Path src, Path dest, StandardCopyOption ... options) throws IORuntimeException {
        return PathUtil.copyFile(src, dest, (CopyOption[])options);
    }

    public static Path copyFile(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Source File is null !", new Object[0]);
        Assert.notNull(target, "Destination File or directiory is null !", new Object[0]);
        Path targetPath = PathUtil.isDirectory(target) ? target.resolve(src.getFileName()) : target;
        PathUtil.mkParentDirs(targetPath);
        try {
            return Files.copy(src, targetPath, options);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static Path copy(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(src)) {
            return PathUtil.copyContent(src, target.resolve(src.getFileName()), options);
        }
        return PathUtil.copyFile(src, target, options);
    }

    public static Path copyContent(Path src, Path target, CopyOption ... options) throws IORuntimeException {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        try {
            Files.walkFileTree(src, new CopyVisitor(src, target, options));
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return target;
    }

    public static boolean isDirectory(Path path2) {
        return PathUtil.isDirectory(path2, false);
    }

    public static boolean isDirectory(Path path2, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path2) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isDirectory(path2, options);
    }

    public static Path getPathEle(Path path2, int index2) {
        return PathUtil.subPath(path2, index2, index2 == -1 ? path2.getNameCount() : index2 + 1);
    }

    public static Path getLastPathEle(Path path2) {
        return PathUtil.getPathEle(path2, path2.getNameCount() - 1);
    }

    public static Path subPath(Path path2, int fromIndex, int toIndex) {
        if (null == path2) {
            return null;
        }
        int len = path2.getNameCount();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return null;
        }
        return path2.subpath(fromIndex, toIndex);
    }

    public static BasicFileAttributes getAttributes(Path path2, boolean isFollowLinks) throws IORuntimeException {
        LinkOption[] linkOptionArray;
        if (null == path2) {
            return null;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        try {
            return Files.readAttributes(path2, BasicFileAttributes.class, options);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static BufferedInputStream getInputStream(Path path2) throws IORuntimeException {
        InputStream in;
        try {
            in = Files.newInputStream(path2, new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return IoUtil.toBuffered(in);
    }

    public static BufferedReader getUtf8Reader(Path path2) throws IORuntimeException {
        return PathUtil.getReader(path2, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(Path path2, Charset charset) throws IORuntimeException {
        return IoUtil.getReader((InputStream)PathUtil.getInputStream(path2), charset);
    }

    public static byte[] readBytes(Path path2) {
        try {
            return Files.readAllBytes(path2);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static BufferedOutputStream getOutputStream(Path path2) throws IORuntimeException {
        OutputStream in;
        try {
            in = Files.newOutputStream(path2, new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        return IoUtil.toBuffered(in);
    }

    public static Path rename(Path path2, String newName, boolean isOverride) {
        return PathUtil.move(path2, path2.resolveSibling(newName), isOverride);
    }

    public static Path move(Path src, Path target, boolean isOverride) {
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (PathUtil.isDirectory(target)) {
            target = target.resolve(src.getFileName());
        }
        return PathUtil.moveContent(src, target, isOverride);
    }

    public static Path moveContent(Path src, Path target, boolean isOverride) {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src path must be not null !", new Object[0]);
        Assert.notNull(target, "Target path must be not null !", new Object[0]);
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        PathUtil.mkParentDirs(target);
        try {
            return Files.move(src, target, options);
        }
        catch (IOException e2) {
            try {
                Files.walkFileTree(src, new MoveVisitor(src, target, options));
                PathUtil.del(src);
            }
            catch (IOException e22) {
                throw new IORuntimeException(e22);
            }
            return target;
        }
    }

    public static boolean equals(Path file1, Path file2) throws IORuntimeException {
        try {
            return Files.isSameFile(file1, file2);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static boolean isFile(Path path2, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (null == path2) {
            return false;
        }
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.isRegularFile(path2, options);
    }

    public static boolean isSymlink(Path path2) {
        return Files.isSymbolicLink(path2);
    }

    public static boolean exists(Path path2, boolean isFollowLinks) {
        LinkOption[] linkOptionArray;
        if (isFollowLinks) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        LinkOption[] options = linkOptionArray;
        return Files.exists(path2, options);
    }

    public static boolean isSub(Path parent, Path sub) {
        return PathUtil.toAbsNormal(sub).startsWith(PathUtil.toAbsNormal(parent));
    }

    public static Path toAbsNormal(Path path2) {
        Assert.notNull(path2);
        return path2.toAbsolutePath().normalize();
    }

    public static String getMimeType(Path file2) {
        try {
            return Files.probeContentType(file2);
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
    }

    public static Path mkdir(Path dir2) {
        if (null != dir2 && !PathUtil.exists(dir2, false)) {
            try {
                Files.createDirectories(dir2, new FileAttribute[0]);
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
        }
        return dir2;
    }

    public static Path mkParentDirs(Path path2) {
        return PathUtil.mkdir(path2.getParent());
    }

    protected static void delFile(Path path2) throws IOException {
        block2: {
            try {
                Files.delete(path2);
            }
            catch (AccessDeniedException e2) {
                if (path2.toFile().delete()) break block2;
                throw e2;
            }
        }
    }
}

