/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.date.TemporalUtil;
import cn.hutool.core.date.format.GlobalCustomFormat;
import cn.hutool.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;

public class TemporalAccessorUtil
extends TemporalUtil {
    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public static String format(TemporalAccessor time2, DateTimeFormatter formatter2) {
        if (null == time2) {
            return null;
        }
        if (null == formatter2) {
            formatter2 = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter2.format(time2);
        }
        catch (UnsupportedTemporalTypeException e2) {
            if (time2 instanceof LocalDate && e2.getMessage().contains("HourOfDay")) {
                return formatter2.format(((LocalDate)time2).atStartOfDay());
            }
            if (time2 instanceof LocalTime && e2.getMessage().contains("YearOfEra")) {
                return formatter2.format(((LocalTime)time2).atDate(LocalDate.now()));
            }
            if (time2 instanceof Instant) {
                return formatter2.format(((Instant)time2).atZone(ZoneId.systemDefault()));
            }
            throw e2;
        }
    }

    public static String format(TemporalAccessor time2, String format2) {
        if (null == time2) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format2)) {
            return GlobalCustomFormat.format(time2, (CharSequence)format2);
        }
        DateTimeFormatter formatter2 = StrUtil.isBlank(format2) ? null : DateTimeFormatter.ofPattern(format2);
        return TemporalAccessorUtil.format(time2, formatter2);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor).toEpochMilli();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }
}

