/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.compress;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    public ZipWriter(File zipFile, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(zipFile, charset);
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this.out = ZipWriter.getZipOutputStream(out, charset);
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment2) {
        this.out.setComment(comment2);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter2, File ... files) throws IORuntimeException {
        for (File file2 : files) {
            String srcRootDir;
            try {
                srcRootDir = file2.getCanonicalPath();
                if (!file2.isDirectory() || withSrcDir) {
                    srcRootDir = file2.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e2) {
                throw new IORuntimeException(e2);
            }
            this._add(file2, srcRootDir, filter2);
        }
        return this;
    }

    public ZipWriter add(Resource ... resources) throws IORuntimeException {
        for (Resource resource2 : resources) {
            if (null == resource2) continue;
            this.add(resource2.getName(), resource2.getStream());
        }
        return this;
    }

    public ZipWriter add(String path2, InputStream in) throws IORuntimeException {
        path2 = StrUtil.nullToEmpty(path2);
        if (null == in && StrUtil.isBlank(path2 = StrUtil.addSuffixIfNot(path2, "/"))) {
            return this;
        }
        return this.putEntry(path2, in);
    }

    @Override
    public void close() throws IORuntimeException {
        try {
            this.out.finish();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close(this.out);
        }
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipWriter.getZipOutputStream(FileUtil.getOutputStream(zipFile), charset);
    }

    private static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, charset);
    }

    private ZipWriter _add(File file2, String srcRootDir, FileFilter filter2) throws IORuntimeException {
        if (null == file2 || null != filter2 && !filter2.accept(file2)) {
            return this;
        }
        String subPath = FileUtil.subPath(srcRootDir, file2);
        if (file2.isDirectory()) {
            File[] files = file2.listFiles();
            if (ArrayUtil.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childFile : files) {
                    this._add(childFile, srcRootDir, filter2);
                }
            }
        } else {
            this.putEntry(subPath, FileUtil.getInputStream(file2));
        }
        return this;
    }

    private ZipWriter putEntry(String path2, InputStream in) throws IORuntimeException {
        try {
            this.out.putNextEntry(new ZipEntry(path2));
            if (null != in) {
                IoUtil.copy(in, this.out);
            }
            this.out.closeEntry();
        }
        catch (IOException e2) {
            throw new IORuntimeException(e2);
        }
        finally {
            IoUtil.close(in);
        }
        IoUtil.flush(this.out);
        return this;
    }
}

