/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.lang.Chain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ComparatorChain<E>
implements Chain<Comparator<E>, ComparatorChain<E>>,
Comparator<E>,
Serializable {
    private static final long serialVersionUID = -2426725788913962429L;
    private final List<Comparator<E>> chain;
    private final BitSet orderingBits;
    private boolean lock = false;

    public static <E> ComparatorChain<E> of(Comparator<E> comparator2) {
        return ComparatorChain.of(comparator2, false);
    }

    public static <E> ComparatorChain<E> of(Comparator<E> comparator2, boolean reverse2) {
        return new ComparatorChain<E>(comparator2, reverse2);
    }

    @SafeVarargs
    public static <E> ComparatorChain<E> of(Comparator<E> ... comparators) {
        return ComparatorChain.of(Arrays.asList(comparators));
    }

    public static <E> ComparatorChain<E> of(List<Comparator<E>> comparators) {
        return new ComparatorChain<E>(comparators);
    }

    public static <E> ComparatorChain<E> of(List<Comparator<E>> comparators, BitSet bits) {
        return new ComparatorChain<E>(comparators, bits);
    }

    public ComparatorChain() {
        this(new ArrayList<Comparator<E>>(), new BitSet());
    }

    public ComparatorChain(Comparator<E> comparator2) {
        this(comparator2, false);
    }

    public ComparatorChain(Comparator<E> comparator2, boolean reverse2) {
        this.chain = new ArrayList<Comparator<E>>(1);
        this.chain.add(comparator2);
        this.orderingBits = new BitSet(1);
        if (reverse2) {
            this.orderingBits.set(0);
        }
    }

    public ComparatorChain(List<Comparator<E>> list) {
        this(list, new BitSet(list.size()));
    }

    public ComparatorChain(List<Comparator<E>> list, BitSet bits) {
        this.chain = list;
        this.orderingBits = bits;
    }

    public ComparatorChain<E> addComparator(Comparator<E> comparator2) {
        return this.addComparator(comparator2, false);
    }

    public ComparatorChain<E> addComparator(Comparator<E> comparator2, boolean reverse2) {
        this.checkLocked();
        this.chain.add(comparator2);
        if (reverse2) {
            this.orderingBits.set(this.chain.size() - 1);
        }
        return this;
    }

    public ComparatorChain<E> setComparator(int index2, Comparator<E> comparator2) throws IndexOutOfBoundsException {
        return this.setComparator(index2, comparator2, false);
    }

    public ComparatorChain<E> setComparator(int index2, Comparator<E> comparator2, boolean reverse2) {
        this.checkLocked();
        this.chain.set(index2, comparator2);
        if (reverse2) {
            this.orderingBits.set(index2);
        } else {
            this.orderingBits.clear(index2);
        }
        return this;
    }

    public ComparatorChain<E> setForwardSort(int index2) {
        this.checkLocked();
        this.orderingBits.clear(index2);
        return this;
    }

    public ComparatorChain<E> setReverseSort(int index2) {
        this.checkLocked();
        this.orderingBits.set(index2);
        return this;
    }

    public int size() {
        return this.chain.size();
    }

    public boolean isLocked() {
        return this.lock;
    }

    @Override
    public Iterator<Comparator<E>> iterator() {
        return this.chain.iterator();
    }

    @Override
    public ComparatorChain<E> addChain(Comparator<E> element) {
        return this.addComparator(element);
    }

    @Override
    public int compare(E o1, E o2) throws UnsupportedOperationException {
        if (!this.lock) {
            this.checkChainIntegrity();
            this.lock = true;
        }
        Iterator<Comparator<E>> comparators = this.chain.iterator();
        int comparatorIndex = 0;
        while (comparators.hasNext()) {
            Comparator<E> comparator2 = comparators.next();
            int retval = comparator2.compare(o1, o2);
            if (retval != 0) {
                if (this.orderingBits.get(comparatorIndex)) {
                    retval = retval > 0 ? -1 : 1;
                }
                return retval;
            }
            ++comparatorIndex;
        }
        return 0;
    }

    public int hashCode() {
        int hash2 = 0;
        if (null != this.chain) {
            hash2 ^= this.chain.hashCode();
        }
        if (null != this.orderingBits) {
            hash2 ^= this.orderingBits.hashCode();
        }
        return hash2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (object.getClass().equals(this.getClass())) {
            ComparatorChain otherChain = (ComparatorChain)object;
            return Objects.equals(this.orderingBits, otherChain.orderingBits) && this.chain.equals(otherChain.chain);
        }
        return false;
    }

    private void checkLocked() {
        if (this.lock) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    private void checkChainIntegrity() {
        if (this.chain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }
}

