/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CollStreamUtil {
    public static <V, K> Map<K, V> toIdentityMap(Collection<V> collection, Function<V, K> key2) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return collection.stream().collect(Collectors.toMap(key2, Function.identity()));
    }

    public static <E, K, V> Map<K, V> toMap(Collection<E> collection, Function<E, K> key2, Function<E, V> value) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return collection.stream().collect(Collectors.toMap(key2, value));
    }

    public static <E, K> Map<K, List<E>> groupByKey(Collection<E> collection, Function<E, K> key2) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return collection.stream().collect(Collectors.groupingBy(key2, Collectors.toList()));
    }

    public static <E, K, U> Map<K, Map<U, List<E>>> groupBy2Key(Collection<E> collection, Function<E, K> key1, Function<E, U> key2) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        return collection.stream().collect(Collectors.groupingBy(key1, Collectors.groupingBy(key2, Collectors.toList())));
    }

    public static <E, T, U> Map<T, Map<U, E>> group2Map(Collection<E> collection, Function<E, T> key1, Function<E, U> key2) {
        if (CollUtil.isEmpty(collection) || key1 == null || key2 == null) {
            return Collections.emptyMap();
        }
        return collection.stream().collect(Collectors.groupingBy(key1, Collectors.toMap(key2, Function.identity())));
    }

    public static <E, T> List<T> toList(Collection<E> collection, Function<E, T> function) {
        if (CollUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <E, T> Set<T> toSet(Collection<E> collection, Function<E, T> function) {
        if (CollUtil.isEmpty(collection) || function == null) {
            return Collections.emptySet();
        }
        return collection.stream().map(function).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <K, X, Y, V> Map<K, V> merge(Map<K, X> map1, Map<K, Y> map2, BiFunction<X, Y, V> merge2) {
        if (MapUtil.isEmpty(map1) && MapUtil.isEmpty(map2)) {
            return Collections.emptyMap();
        }
        if (MapUtil.isEmpty(map1)) {
            map1 = Collections.emptyMap();
        } else if (MapUtil.isEmpty(map2)) {
            map2 = Collections.emptyMap();
        }
        HashSet<K> key2 = new HashSet<K>();
        key2.addAll(map1.keySet());
        key2.addAll(map2.keySet());
        HashMap map3 = new HashMap();
        for (Object t : key2) {
            Object y;
            Object x = map1.get(t);
            V z = merge2.apply(x, y = map2.get(t));
            if (z == null) continue;
            map3.put(t, z);
        }
        return map3;
    }
}

