/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 3794348988671694820L;
    private final int capacity;
    private final Comparator<? super E> comparator;

    public BoundedPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public BoundedPriorityQueue(int capacity, Comparator<? super E> comparator2) {
        super(capacity, (o1, o2) -> {
            int cResult;
            if (comparator2 != null) {
                cResult = comparator2.compare(o1, o2);
            } else {
                Comparable o1c = (Comparable)o1;
                cResult = o1c.compareTo(o2);
            }
            return -cResult;
        });
        this.capacity = capacity;
        this.comparator = comparator2;
    }

    @Override
    public boolean offer(E e2) {
        if (this.size() >= this.capacity) {
            Object head = this.peek();
            if (this.comparator().compare(e2, head) <= 0) {
                return true;
            }
            this.poll();
        }
        return super.offer(e2);
    }

    public boolean addAll(E[] c) {
        return this.addAll(Arrays.asList(c));
    }

    public ArrayList<E> toList() {
        ArrayList<? super E> list = new ArrayList<E>(this);
        list.sort(this.comparator);
        return list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.toList().iterator();
    }
}

