/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.nio.charset.Charset;

public class Base32 {
    private static final String BASE32_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32_LOOKUP = new int[]{255, 255, 26, 27, 28, 29, 30, 31, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255};

    private Base32() {
    }

    public static String encode(byte[] bytes2) {
        int i = 0;
        int index2 = 0;
        StringBuilder base32 = new StringBuilder((bytes2.length + 7) * 8 / 5);
        while (i < bytes2.length) {
            int digit;
            int currByte;
            int n = currByte = bytes2[i] >= 0 ? bytes2[i] : bytes2[i] + 256;
            if (index2 > 3) {
                int nextByte = i + 1 < bytes2.length ? (bytes2[i + 1] >= 0 ? bytes2[i + 1] : bytes2[i + 1] + 256) : 0;
                digit = currByte & 255 >> index2;
                index2 = (index2 + 5) % 8;
                digit <<= index2;
                digit |= nextByte >> 8 - index2;
                ++i;
            } else {
                digit = currByte >> 8 - (index2 + 5) & 0x1F;
                if ((index2 = (index2 + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(BASE32_CHARS.charAt(digit));
        }
        return base32.toString();
    }

    public static String encode(String source2) {
        return Base32.encode(source2, CharsetUtil.CHARSET_UTF_8);
    }

    public static String encode(String source2, String charset) {
        return Base32.encode(StrUtil.bytes((CharSequence)source2, charset));
    }

    public static String encode(String source2, Charset charset) {
        return Base32.encode(StrUtil.bytes((CharSequence)source2, charset));
    }

    public static byte[] decode(String base32) {
        byte[] bytes2 = new byte[base32.length() * 5 / 8];
        int index2 = 0;
        int offset = 0;
        for (int i = 0; i < base32.length(); ++i) {
            int digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup < 0 || lookup >= BASE32_LOOKUP.length || (digit = BASE32_LOOKUP[lookup]) == 255) continue;
            if (index2 <= 3) {
                if ((index2 = (index2 + 5) % 8) == 0) {
                    int n = offset++;
                    bytes2[n] = (byte)(bytes2[n] | digit);
                    if (offset < bytes2.length) continue;
                    break;
                }
                int n = offset;
                bytes2[n] = (byte)(bytes2[n] | digit << 8 - index2);
                continue;
            }
            index2 = (index2 + 5) % 8;
            int n = offset++;
            bytes2[n] = (byte)(bytes2[n] | digit >>> index2);
            if (offset >= bytes2.length) break;
            int n2 = offset;
            bytes2[n2] = (byte)(bytes2[n2] | digit << 8 - index2);
        }
        return bytes2;
    }

    public static String decodeStr(String source2) {
        return Base32.decodeStr(source2, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decodeStr(String source2, String charset) {
        return StrUtil.str(Base32.decode(source2), charset);
    }

    public static String decodeStr(String source2, Charset charset) {
        return StrUtil.str(Base32.decode(source2), charset);
    }
}

