/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean.copier.provider;

import cn.hutool.core.bean.copier.ValueProvider;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class MapValueProvider
implements ValueProvider<String> {
    private final Map<?, ?> map;
    private final boolean ignoreError;

    public MapValueProvider(Map<?, ?> map2, boolean ignoreCase) {
        this(map2, ignoreCase, false);
    }

    public MapValueProvider(Map<?, ?> map2, boolean ignoreCase, boolean ignoreError) {
        this.map = false == ignoreCase || map2 instanceof CaseInsensitiveMap ? map2 : new CaseInsensitiveMap(map2);
        this.ignoreError = ignoreError;
    }

    @Override
    public Object value(String key2, Type valueType) {
        String key1 = this.getKey(key2, valueType);
        if (null == key1) {
            return null;
        }
        return Convert.convertWithCheck(valueType, this.map.get(key1), null, this.ignoreError);
    }

    @Override
    public boolean containsKey(String key2) {
        return null != this.getKey(key2, null);
    }

    private String getKey(String key2, Type valueType) {
        if (this.map.containsKey(key2)) {
            return key2;
        }
        String customKey = StrUtil.toUnderlineCase(key2);
        if (this.map.containsKey(customKey)) {
            return customKey;
        }
        if (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType) {
            customKey = StrUtil.upperFirstAndAddPre(key2, "is");
            if (this.map.containsKey(customKey)) {
                return customKey;
            }
            if (this.map.containsKey(customKey = StrUtil.toUnderlineCase(customKey))) {
                return customKey;
            }
        }
        return null;
    }
}

