/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.bean;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.PropIgnore;
import cn.hutool.core.bean.BeanException;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.TypeUtil;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class PropDesc {
    final Field field;
    protected Method getter;
    protected Method setter;

    public PropDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = ClassUtil.setAccessible(getter);
        this.setter = ClassUtil.setAccessible(setter);
    }

    public String getFieldName() {
        return ReflectUtil.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeUtil.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeUtil.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    public Object getValue(Object bean2) {
        if (null != this.getter) {
            return ReflectUtil.invoke(bean2, this.getter, new Object[0]);
        }
        if (ModifierUtil.isPublic(this.field)) {
            return ReflectUtil.getFieldValue(bean2, this.field);
        }
        return null;
    }

    public Object getValue(Object bean2, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean2);
            }
            catch (Exception e2) {
                if (ignoreError) break block3;
                throw new BeanException(e2, "Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !ModifierUtil.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    public PropDesc setValue(Object bean2, Object value) {
        if (null != this.setter) {
            ReflectUtil.invoke(bean2, this.setter, value);
        } else if (ModifierUtil.isPublic(this.field)) {
            ReflectUtil.setFieldValue(bean2, this.field, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean2, Object value, boolean ignoreNull, boolean ignoreError) {
        block5: {
            Class<?> propClass;
            if (ignoreNull && null == value) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean2, value);
                }
                catch (Exception e2) {
                    if (ignoreError) break block5;
                    throw new BeanException(e2, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method getter, Method setter) {
        Type type2 = null;
        if (null != getter) {
            type2 = TypeUtil.getReturnType(getter);
        }
        if (null == type2 && null != setter) {
            type2 = TypeUtil.getParamType(setter, 0);
        }
        return type2;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type2 = null;
        if (null != getter) {
            type2 = TypeUtil.getReturnClass(getter);
        }
        if (null == type2 && null != setter) {
            type2 = TypeUtil.getFirstParamClass(setter);
        }
        return type2;
    }

    private boolean isIgnoreSet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.setter, PropIgnore.class);
    }

    private boolean isIgnoreGet() {
        return AnnotationUtil.hasAnnotation(this.field, PropIgnore.class) || AnnotationUtil.hasAnnotation(this.getter, PropIgnore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = ModifierUtil.hasModifier(this.getter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = ModifierUtil.hasModifier(this.field, ModifierUtil.ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = ModifierUtil.hasModifier(this.setter, ModifierUtil.ModifierType.TRANSIENT))) {
            isTransient = AnnotationUtil.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

