/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.img.gif.AnimatedGifEncoder;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class GifCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = 7091627304326538464L;
    private int quality = 10;
    private int repeat = 0;
    private int minColor = 0;
    private int maxColor = 255;

    public GifCaptcha(int width, int height) {
        this(width, height, 5);
    }

    public GifCaptcha(int width, int height, int codeCount) {
        super(width, height, codeCount, 10);
    }

    public GifCaptcha setQuality(int quality) {
        if (quality < 1) {
            quality = 1;
        }
        this.quality = quality;
        return this;
    }

    public GifCaptcha setRepeat(int repeat2) {
        if (repeat2 >= 0) {
            this.repeat = repeat2;
        }
        return this;
    }

    public GifCaptcha setMaxColor(int maxColor) {
        this.maxColor = maxColor;
        return this;
    }

    public GifCaptcha setMinColor(int minColor) {
        this.minColor = minColor;
        return this;
    }

    @Override
    public void createCode() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AnimatedGifEncoder gifEncoder = new AnimatedGifEncoder();
        gifEncoder.start(out);
        gifEncoder.setQuality(this.quality);
        int delay2 = 100;
        gifEncoder.setDelay(delay2);
        gifEncoder.setRepeat(this.repeat);
        char[] chars2 = this.code.toCharArray();
        Color[] fontColor = new Color[chars2.length];
        for (int i = 0; i < chars2.length; ++i) {
            fontColor[i] = this.getRandomColor(this.minColor, this.maxColor);
            BufferedImage frame = this.graphicsImage(chars2, fontColor, chars2, i);
            gifEncoder.addFrame(frame);
            frame.flush();
        }
        gifEncoder.finish();
        this.imageBytes = out.toByteArray();
    }

    @Override
    protected Image createImage(String code) {
        return null;
    }

    private BufferedImage graphicsImage(char[] chars2, Color[] fontColor, char[] words, int flag) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(ObjectUtil.defaultIfNull(this.background, Color.WHITE));
        g2d.fillRect(0, 0, this.width, this.height);
        float y = (this.height >> 1) + (this.font.getSize() >> 1);
        float m = 1.0f * (float)(this.width - chars2.length * this.font.getSize()) / (float)chars2.length;
        float x = Math.max(m / 2.0f, 2.0f);
        g2d.setFont(this.font);
        if (null != this.textAlpha) {
            g2d.setComposite(this.textAlpha);
        }
        for (int i = 0; i < chars2.length; ++i) {
            AlphaComposite ac = AlphaComposite.getInstance(3, this.getAlpha(chars2.length, flag, i));
            g2d.setComposite(ac);
            g2d.setColor(fontColor[i]);
            g2d.drawOval(RandomUtil.randomInt(this.width), RandomUtil.randomInt(this.height), RandomUtil.randomInt(5, 30), 5 + RandomUtil.randomInt(5, 30));
            g2d.drawString(words[i] + "", x + ((float)this.font.getSize() + m) * (float)i, y);
        }
        g2d.dispose();
        return image;
    }

    private float getAlpha(int v, int i, int j) {
        int num2 = i + j;
        float r = 1.0f / (float)v;
        float s = (float)(v + 1) * r;
        return num2 > v ? (float)num2 * r - s : (float)num2 * r;
    }

    private Color getRandomColor(int min2, int max2) {
        if (min2 > 255) {
            min2 = 255;
        }
        if (max2 > 255) {
            max2 = 255;
        }
        if (min2 < 0) {
            min2 = 0;
        }
        if (max2 < 0) {
            max2 = 0;
        }
        if (min2 > max2) {
            min2 = 0;
            max2 = 255;
        }
        return new Color(RandomUtil.randomInt(min2, max2), RandomUtil.randomInt(min2, max2), RandomUtil.randomInt(min2, max2));
    }
}

